/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.util.poi.excel.table;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.util.poi.excel.table.IfExcelTable;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;

public abstract class ExcelTable<T>
implements IfExcelTable<T> {
    @NotNull
    @Nonnull
    protected String sheetName;
    @Nullable
    @Min(value=1L)
    protected @Min(value=1L) Integer tableStartRowNumber;
    @Min(value=1L)
    protected @Min(value=1L) int tableStartColumnNumber;
    protected boolean ignoresAdditionalColumnsOfHeaderData;
    protected boolean isVerticalAndHorizontalOpposite;

    public ExcelTable(@RequireNonnull String sheetName, @Nullable Integer tableStartRowNumber, int tableStartColumnNumber) {
        this.sheetName = (String)ObjectsUtil.requireNonNull((Object)sheetName);
        this.tableStartRowNumber = tableStartRowNumber;
        this.tableStartColumnNumber = tableStartColumnNumber;
    }

    @Override
    @Nonnull
    public String getSheetName() {
        return (String)ObjectsUtil.requireNonNull((Object)this.sheetName);
    }

    public int getPoiBasisDeterminedTableStartRowNumber(@RequireNonnull Sheet sheet, int excelBasisTableStartColumnNumber) {
        ObjectsUtil.requireNonNull((Object)sheet);
        int poiBasisTableStartColumnNumber = excelBasisTableStartColumnNumber - 1;
        if (this.tableStartRowNumber != null) {
            return Objects.requireNonNull(this.tableStartRowNumber) - 1;
        }
        for (int i = 0; i < 100; ++i) {
            String value;
            Cell cell;
            if (this.isVerticalAndHorizontalOpposite) {
                row = sheet.getRow(poiBasisTableStartColumnNumber);
                if (row == null) break;
                cell = row.getCell(i);
            } else {
                row = sheet.getRow(i);
                if (row == null) continue;
                cell = row.getCell(poiBasisTableStartColumnNumber);
            }
            if (cell == null || !(value = cell.getStringCellValue()).equals(this.getFarLeftAndTopHeaderLabel())) continue;
            return i;
        }
        throw new RuntimeException("\u30b7\u30fc\u30c8\u300c" + sheet.getSheetName() + "\u300d\u306b\u6587\u5b57\u5217\u300c" + this.getFarLeftAndTopHeaderLabel() + "\u300d\u304c" + this.tableStartColumnNumber + "\u756a\u76ee\u306e\u5217\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u7d42\u4e86\u3057\u307e\u3059\u3002");
    }

    public int getPoiBasisDeterminedTableStartColumnNumber() {
        return this.tableStartColumnNumber - 1;
    }

    @Override
    public boolean ignoresAdditionalColumnsOfHeaderData() {
        return this.ignoresAdditionalColumnsOfHeaderData;
    }

    @Override
    public boolean isVerticalAndHorizontalOpposite() {
        return this.isVerticalAndHorizontalOpposite;
    }

    public static class ContextContainer {
        public final Sheet sheet;
        public final int poiBasisTableStartRowNumber;
        public final int poiBasisTableStartColumnNumber;
        public final Integer tableRowSize;
        public final Integer tableColumnSize;
        public static final int max = 10000;

        public ContextContainer(Sheet sheet, int poiBasisTableStartRowNumber, int poiBasisTableStartColumnNumber, Integer tableRowSize, Integer tableColumnSize) {
            this.sheet = sheet;
            this.poiBasisTableStartRowNumber = poiBasisTableStartRowNumber;
            this.poiBasisTableStartColumnNumber = poiBasisTableStartColumnNumber;
            this.tableRowSize = tableRowSize;
            this.tableColumnSize = tableColumnSize;
        }
    }
}

