/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.util.poi.excel.util;

import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.text.Format;
import java.time.format.DateTimeFormatter;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import jp.ecuacion.util.poi.excel.exception.ExcelAppException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.ExcelStyleDateFormatter;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelReadUtil {
    private static DetailLogger detailLog = new DetailLogger(ExcelReadUtil.class);
    private static final String EMPTY_STRING = "";
    private static DateTimeFormatter defaultDateTimeFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    private ExcelReadUtil() {
    }

    @Nullable
    public static String getNoDataStringIfNoData(@Nullable String value, String noDataString) {
        if (value == null || value.equals(EMPTY_STRING)) {
            return noDataString;
        }
        return value;
    }

    @Nullable
    public static String getStringFromCell(@Nullable Cell cell) throws ExcelAppException {
        return ExcelReadUtil.getStringFromCell(cell, null, defaultDateTimeFormat);
    }

    @Nullable
    public static String getStringFromCell(@Nullable Cell cell, @Nullable String filename) throws ExcelAppException {
        return ExcelReadUtil.getStringFromCell(cell, filename, defaultDateTimeFormat);
    }

    @Nullable
    public static String getStringFromCell(@Nullable Cell cell, @Nullable String filename, DateTimeFormatter dateTimeFormat) throws ExcelAppException {
        return ExcelReadUtil.getStringFromCell(cell, filename, dateTimeFormat, null);
    }

    @Nullable
    public static String getStringFromCell(@Nullable Cell cell, @Nullable String filename, DateTimeFormatter dateTimeFormat, String noDataString) throws ExcelAppException {
        if (dateTimeFormat == null) {
            dateTimeFormat = defaultDateTimeFormat;
        }
        String cellTypeString = null;
        cellTypeString = cell == null ? "(cell is null)" : cell.getCellType().toString();
        detailLog.debug("-----");
        detailLog.debug("cellType: " + cellTypeString);
        String value = ExcelReadUtil.internalGetStringFromCell(cell, filename, dateTimeFormat, noDataString);
        detailLog.debug("value: " + (value == null ? "(null)" : value));
        return value;
    }

    @Nullable
    private static String internalGetStringFromCell(@Nullable Cell cell, @Nullable String filename, DateTimeFormatter dateTimeFormat, String noDataString) throws ExcelAppException {
        if (cell == null) {
            return noDataString;
        }
        CellType cellType = cell.getCellType();
        if (cellType == CellType.FORMULA) {
            return ExcelReadUtil.internalGetStringFromCellOtherThanFormulaCellType(cell, filename, cell.getCachedFormulaResultType(), noDataString, dateTimeFormat);
        }
        return ExcelReadUtil.internalGetStringFromCellOtherThanFormulaCellType(cell, filename, cell.getCellType(), noDataString, dateTimeFormat);
    }

    @Nullable
    private static String internalGetStringFromCellOtherThanFormulaCellType(@RequireNonnull Cell cell, @Nullable String filename, @Nullable CellType cellType, String noDataString, DateTimeFormatter dateTimeFormat) throws ExcelAppException {
        if (cellType == CellType.BLANK) {
            return noDataString;
        }
        if (cellType == CellType.STRING) {
            return ExcelReadUtil.getNoDataStringIfNoData(cell.getStringCellValue(), noDataString);
        }
        if (cellType == CellType.NUMERIC) {
            DataFormatter fmter = new DataFormatter();
            Format fmt = fmter.createFormat(cell);
            detailLog.debug("Format: " + (fmt == null ? "(null)" : fmt.getClass().getSimpleName()));
            if (fmt == null) {
                return Double.toString(cell.getNumericCellValue());
            }
            if (fmt instanceof ExcelStyleDateFormatter) {
                return cell.getLocalDateTimeCellValue().format(dateTimeFormat);
            }
            String fmtVal = fmt.format(cell.getNumericCellValue());
            String toStrVal = Double.valueOf(cell.getNumericCellValue()).toString();
            boolean warning = false;
            if (!(fmtVal.equals(toStrVal) || fmtVal.contains(".") || toStrVal.endsWith(".0") && fmtVal.equals(toStrVal.substring(0, toStrVal.indexOf("."))))) {
                warning = true;
            }
            if (warning) {
                detailLog.debug("The number actual and displayed in excel differs. actual: " + toStrVal + "\u3001displayed: " + fmtVal);
            }
            return fmtVal;
        }
        if (cellType == CellType.ERROR) {
            Object[] objectArray;
            Object[] objectArray2 = PropertyFileUtil.Arg.strings((String[])new String[]{cell.getRow().getSheet().getSheetName(), cell.getAddress().formatAsString()});
            if (StringUtils.isEmpty((CharSequence)filename)) {
                objectArray = PropertyFileUtil.Arg.strings((String[])new String[]{EMPTY_STRING, EMPTY_STRING});
            } else {
                Object[] objectArray3 = new PropertyFileUtil.Arg[2];
                objectArray3[0] = PropertyFileUtil.Arg.message((String)"jp.ecuacion.util.poi.common.messageItemSeparator");
                objectArray = objectArray3;
                objectArray3[1] = PropertyFileUtil.Arg.message((String)"jp.ecuacion.util.poi.common.filename", (String[])new String[]{filename});
            }
            throw new ExcelAppException("jp.ecuacion.util.poi.excel.CellContainsError.message", (PropertyFileUtil.Arg[])ArrayUtils.addAll((Object[])objectArray2, (Object[])objectArray));
        }
        throw new RuntimeException("cell type not found. cellType: " + cellType.toString());
    }

    public static Workbook openForRead(String filePath) throws EncryptedDocumentException, IOException {
        return WorkbookFactory.create((File)new File(filePath), null, (boolean)true);
    }
}

