/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.util.poi.excel.table.reader;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Min;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.unchecked.UncheckedAppException;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.lib.core.util.ValidationUtil;
import jp.ecuacion.util.poi.excel.exception.ExcelAppException;
import jp.ecuacion.util.poi.excel.exception.LoopBreakException;
import jp.ecuacion.util.poi.excel.table.ExcelTable;
import jp.ecuacion.util.poi.excel.table.reader.IfExcelTableReader;
import jp.ecuacion.util.poi.excel.util.ExcelReadUtil;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class ExcelTableReader<T>
extends ExcelTable<T>
implements IfExcelTableReader<T> {
    private static DetailLogger detailLog = new DetailLogger(ExcelTableReader.class);
    @Min(value=1L)
    protected @Min(value=1L) Integer tableRowSizeGivenByConstructor;
    @Min(value=1L)
    protected @Min(value=1L) Integer tableColumnSizeGivenByConstructor;

    public ExcelTableReader(@RequireNonnull String sheetName, @Nullable Integer tableStartRowNumber, int tableStartColumnNumber, @Nullable Integer tableRowSize, @Nullable Integer tableColumnSize) {
        super(sheetName, tableStartRowNumber, tableStartColumnNumber);
        this.tableRowSizeGivenByConstructor = tableRowSize;
        this.tableColumnSizeGivenByConstructor = tableColumnSize;
        Set violationSet = ValidationUtil.validate((Object)this);
        if (violationSet != null && violationSet.size() > 0) {
            throw new RuntimeException("Validation failed at TableReader constructor.");
        }
    }

    @Nonnull
    public List<List<T>> read(@RequireNonnull String filePath) throws EncryptedDocumentException, AppException, IOException {
        ObjectsUtil.requireNonNull((Object)filePath);
        try (Workbook excel = ExcelReadUtil.openForRead(filePath);){
            List<List<T>> list = this.read(excel);
            return list;
        }
    }

    @Nonnull
    public List<List<T>> read(@RequireNonnull Workbook workbook) throws EncryptedDocumentException, AppException, IOException {
        List<List<T>> headerData = this.readTableData(workbook, true);
        this.validateHeaderData(headerData);
        List<List<T>> rtnData = this.readTableData(workbook);
        this.updateAndGetHeaderData(rtnData);
        return rtnData;
    }

    @Nonnull
    public Iterable<List<T>> getIterable(@RequireNonnull Workbook workbook) throws EncryptedDocumentException, AppException, IOException {
        List<List<T>> headerData = this.readTableData(workbook, true);
        this.validateHeaderData(headerData);
        List<List<T>> rtnData = this.readTableData(workbook);
        this.updateAndGetHeaderData(rtnData);
        ExcelTable.ContextContainer context = ExcelTableReader.getReadyToReadTableData(this, workbook, this.getSheetName(), this.tableStartColumnNumber, null, false);
        return new IterableReader(this, context, this.getNumberOfHeaderLines());
    }

    private List<List<T>> readTableData(Workbook workbook) throws AppException {
        return this.readTableData(workbook, false);
    }

    @Nonnull
    private List<List<T>> readTableData(@RequireNonnull Workbook workbook, boolean readsHeaderOnly) throws AppException {
        ExcelTable.ContextContainer context = ExcelTableReader.getReadyToReadTableData(this, workbook, this.getSheetName(), this.tableStartColumnNumber, readsHeaderOnly ? Integer.valueOf(this.getNumberOfHeaderLines()) : null, readsHeaderOnly);
        ArrayList<List<T>> rowList = new ArrayList<List<T>>();
        try {
            for (int rowNumber = context.poiBasisTableStartRowNumber; rowNumber <= 10000; ++rowNumber) {
                List<T> colList = ExcelTableReader.readTableLine(this, context, rowNumber);
                rowList.add(colList);
            }
        }
        catch (LoopBreakException loopBreakException) {
            // empty catch block
        }
        detailLog.debug("finishing to read excel file. sheet name :" + this.getSheetName());
        detailLog.debug("===============");
        return rowList;
    }

    @Nullable
    public Integer getTableRowSize() {
        return this.tableRowSizeGivenByConstructor;
    }

    @Nonnull
    public Integer getTableColumnSize(@RequireNonnull Sheet sheet, int poiBasisDeterminedTableStartRowNumber, int poiBasisDeterminedTableStartColumnNumber, boolean ignoresColumnSizeSetInReader) throws ExcelAppException {
        int size;
        ObjectsUtil.requireNonNull((Object)sheet);
        if (this.tableColumnSizeGivenByConstructor != null && !ignoresColumnSizeSetInReader) {
            return this.tableColumnSizeGivenByConstructor;
        }
        int columnNumber = poiBasisDeterminedTableStartColumnNumber;
        while (true) {
            Cell cell;
            if (this.isVerticalAndHorizontalOpposite) {
                row = sheet.getRow(columnNumber);
                if (row == null || row.getCell(poiBasisDeterminedTableStartRowNumber) == null) break;
                cell = row.getCell(poiBasisDeterminedTableStartRowNumber);
            } else {
                row = sheet.getRow(poiBasisDeterminedTableStartRowNumber);
                if (row == null || row.getCell(columnNumber) == null) break;
                cell = row.getCell(columnNumber);
            }
            if (this.isCellDataEmpty(this.getCellData(cell, this.tableStartColumnNumber + columnNumber + 1))) break;
            ++columnNumber;
        }
        if ((size = columnNumber - poiBasisDeterminedTableStartColumnNumber) == 0) {
            throw new ExcelAppException("jp.ecuacion.util.poi.excel.reader.ColumnSizeIsZero.message", sheet.getSheetName(), Integer.toString(poiBasisDeterminedTableStartRowNumber + 1), Integer.toString(poiBasisDeterminedTableStartColumnNumber + 1)).sheet(sheet);
        }
        return size;
    }

    public void setTableColumnSize(int tableColumnSize) {
        this.tableColumnSizeGivenByConstructor = tableColumnSize;
    }

    static <T> List<T> readTableLine(ExcelTableReader<T> reader, ExcelTable.ContextContainer context, int rowNumber) throws ExcelAppException {
        detailLog.debug("----------");
        detailLog.debug("row number\uff1a" + rowNumber);
        if (rowNumber == 10000) {
            throw new RuntimeException("'max':10000 exceeded.");
        }
        if (context.tableRowSize != null && rowNumber >= context.poiBasisTableStartRowNumber + context.tableRowSize) {
            throw new LoopBreakException();
        }
        ArrayList colList = new ArrayList();
        boolean isEmptyRow = true;
        for (int j = context.poiBasisTableStartColumnNumber; j < context.poiBasisTableStartColumnNumber + context.tableColumnSize; ++j) {
            Object cellData;
            Cell cell;
            Row row;
            if (reader.isVerticalAndHorizontalOpposite()) {
                row = context.sheet.getRow(j);
                if (row == null || row.getCell(rowNumber) == null) {
                    colList.add(null);
                    continue;
                }
                cell = row.getCell(rowNumber);
                cellData = reader.getCellData(cell, j + 1);
                colList.add(cellData);
                continue;
            }
            row = context.sheet.getRow(rowNumber);
            if (row == null || row.getCell(j) == null) {
                colList.add(null);
                continue;
            }
            cell = row.getCell(j);
            cellData = reader.getCellData(cell, j + 1);
            colList.add(cellData);
        }
        for (Object colData : colList) {
            if (reader.isCellDataEmpty(colData)) continue;
            isEmptyRow = false;
            break;
        }
        if (isEmptyRow) {
            detailLog.debug("(no data in the line)");
            detailLog.debug("----------");
            if (context.tableRowSize == null) {
                throw new LoopBreakException();
            }
            return new ArrayList();
        }
        return colList;
    }

    public static <T> ExcelTable.ContextContainer getReadyToReadTableData(ExcelTableReader<T> reader, Workbook workbook, String sheetName, int tableStartColumnNumber, Integer numberOfHeaderLinesIfReadsHeaderOnlyOrNull, boolean ignoresColumnSizeSetInReader) throws ExcelAppException {
        detailLog.debug("===============");
        detailLog.debug("starting to read excel file.");
        detailLog.debug("sheet name :" + sheetName);
        Sheet sheet = workbook.getSheet(sheetName);
        if (sheet == null) {
            throw new ExcelAppException("jp.ecuacion.util.poi.excel.SheetNotExist.message", sheetName);
        }
        Integer tableRowSize = numberOfHeaderLinesIfReadsHeaderOnlyOrNull == null ? reader.getTableRowSize() : numberOfHeaderLinesIfReadsHeaderOnlyOrNull;
        int poiBasisTableStartRowNumber = reader.getPoiBasisDeterminedTableStartRowNumber(sheet, tableStartColumnNumber);
        int poiBasisTableStartColumnNumber = reader.getPoiBasisDeterminedTableStartColumnNumber();
        ExcelTable.ContextContainer context = new ExcelTable.ContextContainer(sheet, poiBasisTableStartRowNumber, poiBasisTableStartColumnNumber, tableRowSize, reader.getTableColumnSize(sheet, poiBasisTableStartRowNumber, poiBasisTableStartColumnNumber, ignoresColumnSizeSetInReader));
        return context;
    }

    @Override
    public ExcelTableReader<T> ignoresAdditionalColumnsOfHeaderData(boolean value) {
        this.ignoresAdditionalColumnsOfHeaderData = value;
        return this;
    }

    @Override
    public ExcelTableReader<T> isVerticalAndHorizontalOpposite(boolean value) {
        this.isVerticalAndHorizontalOpposite = value;
        return this;
    }

    public static class IterableReader<T>
    implements Iterable<List<T>> {
        private IteratorReader<T> iterator;

        public IterableReader(ExcelTableReader<T> reader, ExcelTable.ContextContainer context, int numberOfheaderLines) {
            this.iterator = new IteratorReader<T>(reader, context, numberOfheaderLines);
        }

        @Override
        public Iterator<List<T>> iterator() {
            return this.iterator;
        }
    }

    public static class IteratorReader<T>
    implements Iterator<List<T>> {
        private ExcelTableReader<T> reader;
        private ExcelTable.ContextContainer context;
        private boolean hasNext = true;
        private int rowNumber;

        public IteratorReader(ExcelTableReader<T> reader, ExcelTable.ContextContainer context, int numberOfheaderLines) {
            this.reader = reader;
            this.context = context;
            this.rowNumber = context.poiBasisTableStartRowNumber + numberOfheaderLines;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public List<T> next() {
            List<T> rtn = null;
            try {
                rtn = ExcelTableReader.readTableLine(this.reader, this.context, this.rowNumber);
                ++this.rowNumber;
                try {
                    ExcelTableReader.readTableLine(this.reader, this.context, this.rowNumber);
                }
                catch (LoopBreakException ex) {
                    this.hasNext = false;
                }
                return rtn;
            }
            catch (ExcelAppException ex) {
                throw new UncheckedAppException((AppException)ex);
            }
        }
    }
}

