/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.util.poi.excel.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.lib.core.util.ExceptionUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import jp.ecuacion.util.poi.excel.exception.ExcelAppException;
import jp.ecuacion.util.poi.excel.table.ExcelTable;
import jp.ecuacion.util.poi.excel.table.writer.ExcelTableWriter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ss.formula.CollaboratingWorkbooksEnvironment;
import org.apache.poi.ss.formula.eval.NotImplementedException;
import org.apache.poi.ss.formula.eval.NotImplementedFunctionException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelWriteUtil {
    private static final String MSG_PREFIX = "jp.ecuacion.util.poi.excel.ExcelWriteUtil.";
    private static DetailLogger detailLog = new DetailLogger(ExcelWriteUtil.class);

    public static Workbook createWorkbookWithSheet(String sheetName) {
        XSSFWorkbook wb = new XSSFWorkbook();
        wb.createSheet(sheetName);
        return wb;
    }

    public static Workbook openForWrite(String filePath) throws EncryptedDocumentException, IOException {
        return WorkbookFactory.create((InputStream)new FileInputStream(filePath));
    }

    public static FileOutputStream openForOutput(String filePath) throws EncryptedDocumentException, IOException {
        return new FileOutputStream(filePath);
    }

    public static void saveToFile(Workbook workbook, FileOutputStream out) throws EncryptedDocumentException, IOException {
        workbook.write((OutputStream)out);
    }

    public static <T> ExcelTable.ContextContainer getReadyToWriteTableData(ExcelTableWriter<T> writer, Workbook workbook, String sheetName, int tableStartColumnNumber) throws ExcelAppException {
        detailLog.debug("===============");
        detailLog.debug("starting to write excel file.");
        detailLog.debug("sheet name :" + sheetName);
        Sheet sheet = workbook.getSheet(sheetName);
        if (sheet == null) {
            throw new ExcelAppException("jp.ecuacion.util.poi.excel.SheetNotExist.message", sheetName);
        }
        int poiBasisTableStartColumnNumber = writer.getPoiBasisDeterminedTableStartColumnNumber();
        int poiBasisTableStartRowNumber = writer.getPoiBasisDeterminedTableStartRowNumber(sheet, tableStartColumnNumber);
        return new ExcelTable.ContextContainer(sheet, poiBasisTableStartRowNumber, poiBasisTableStartColumnNumber, null, null);
    }

    public static <T> void writeTableLine(ExcelTableWriter<T> writer, ExcelTable.ContextContainer context, int rowNumber, List<T> columnList) {
        if (context.sheet.getRow(rowNumber) == null) {
            context.sheet.createRow(rowNumber);
        }
        for (int colNumber = context.poiBasisTableStartColumnNumber; colNumber < context.poiBasisTableStartColumnNumber + columnList.size(); ++colNumber) {
            Cell destCell;
            if (writer.isVerticalAndHorizontalOpposite()) {
                row = context.sheet.getRow(colNumber);
                if (row == null) {
                    row = context.sheet.createRow(colNumber);
                }
                if (row.getCell(rowNumber) == null) {
                    row.createCell(rowNumber);
                }
                destCell = row.getCell(rowNumber);
            } else {
                row = context.sheet.getRow(rowNumber);
                if (row == null) {
                    row = context.sheet.createRow(rowNumber);
                }
                if (row.getCell(colNumber) == null) {
                    row.createCell(colNumber);
                }
                destCell = row.getCell(colNumber);
            }
            T sourceCellData = columnList.get(colNumber - context.poiBasisTableStartColumnNumber);
            writer.writeToCell(colNumber - context.poiBasisTableStartColumnNumber, sourceCellData, destCell);
        }
    }

    public static void getReadyToEvaluateFormula(Cell cell, boolean changesNumberString, boolean changesDateString, boolean changesCellsWithTextDataFormat, String[] dateFormats) {
        boolean skipsBecauseOfDataFormat;
        boolean bl = skipsBecauseOfDataFormat = !changesCellsWithTextDataFormat && cell.getCellStyle().getDataFormat() == 49;
        if (cell != null && cell.getCellType() == CellType.STRING && !skipsBecauseOfDataFormat) {
            if (changesNumberString) {
                try {
                    Double d = Double.parseDouble(cell.getStringCellValue().replaceAll(",", ""));
                    cell.setCellValue(d.doubleValue());
                }
                catch (Exception ex) {
                    detailLog.trace("String does not match the number format.");
                }
            }
            if (changesDateString) {
                for (String dateFormat : dateFormats) {
                    try {
                        LocalDate locDate = LocalDate.parse(cell.getStringCellValue(), DateTimeFormatter.ofPattern(dateFormat));
                        cell.setCellValue(DateUtil.getExcelDate((LocalDate)locDate));
                        break;
                    }
                    catch (Exception ex) {
                        detailLog.trace("String does not match the number format.");
                    }
                }
            }
        }
    }

    public static void evaluateFormula(Workbook workbook, String fileInfo, boolean breaksOnError) throws AppException {
        Iterator sheetIt = workbook.sheetIterator();
        while (sheetIt.hasNext()) {
            Sheet sheet = (Sheet)sheetIt.next();
            ExcelWriteUtil.evaluateFormula(sheet, fileInfo, breaksOnError);
        }
    }

    public static void evaluateFormula(Workbook workbook, String fileInfo, boolean breaksOnError, String ... sheetNames) throws AppException {
        for (String sheetName : sheetNames) {
            Sheet sheet = workbook.getSheet(sheetName);
            ExcelWriteUtil.evaluateFormula(sheet, fileInfo, breaksOnError);
        }
    }

    private static void evaluateFormula(Sheet sheet, String fileInfo, boolean breaksOnError) throws AppException {
        ArrayList<ExcelAppException> exList = new ArrayList<ExcelAppException>();
        Iterator rowIt = sheet.rowIterator();
        while (rowIt.hasNext()) {
            Row row = (Row)rowIt.next();
            Iterator cellIt = row.cellIterator();
            while (cellIt.hasNext()) {
                Cell cell = (Cell)cellIt.next();
                try {
                    ExcelWriteUtil.evaluateFormula(cell, fileInfo);
                }
                catch (ExcelAppException ex) {
                    if (breaksOnError) {
                        throw ex;
                    }
                    exList.add(ex);
                }
            }
        }
        if (!breaksOnError && exList.size() > 0) {
            throw new MultipleAppException(exList);
        }
    }

    public static void evaluateFormula(Cell cell, String fileInfo) throws ExcelAppException {
        PropertyFileUtil.Arg fileInfoArg = ExcelWriteUtil.getFileInfoString(fileInfo);
        Workbook workbook = cell.getRow().getSheet().getWorkbook();
        String sheetName = cell.getSheet().getSheetName();
        String cellAddress = cell.getAddress().formatAsString();
        try {
            workbook.getCreationHelper().createFormulaEvaluator().evaluateFormulaCell(cell);
        }
        catch (NotImplementedException ex) {
            PropertyFileUtil.Arg reason = null;
            if (ex.getCause() instanceof NotImplementedFunctionException) {
                NotImplementedFunctionException cause = (NotImplementedFunctionException)ex.getCause();
                String msg = "jp.ecuacion.util.poi.excel.ExcelWriteUtil.NotImplementedException.ReasonUnimplementedFunction.message";
                reason = PropertyFileUtil.Arg.message((String)msg, (PropertyFileUtil.Arg[])new PropertyFileUtil.Arg[]{PropertyFileUtil.Arg.string((String)cause.getFunctionName().replace("_xlfn.", ""))});
            } else {
                reason = PropertyFileUtil.Arg.message((String)"jp.ecuacion.util.poi.excel.ExcelWriteUtil.NotImplementedException.ReasonUnknown.message", (PropertyFileUtil.Arg[])new PropertyFileUtil.Arg[0]);
            }
            PropertyFileUtil.Arg[] args = (PropertyFileUtil.Arg[])ArrayUtils.addAll((Object[])PropertyFileUtil.Arg.strings((String[])new String[]{sheetName, cellAddress}), (Object[])new PropertyFileUtil.Arg[]{reason, fileInfoArg});
            throw new ExcelAppException("jp.ecuacion.util.poi.excel.ExcelWriteUtil.NotImplementedException.message", args).cell(cell).cause(ex);
        }
        catch (IllegalStateException ex) {
            if (ex.getCause() != null && ex.getCause().getCause() != null && ex.getCause().getCause() instanceof CollaboratingWorkbooksEnvironment.WorkbookNotFoundException) {
                PropertyFileUtil.Arg[] args = (PropertyFileUtil.Arg[])ArrayUtils.addAll((Object[])PropertyFileUtil.Arg.strings((String[])new String[]{sheetName, cellAddress, cell.getCellFormula()}), (Object[])new PropertyFileUtil.Arg[]{fileInfoArg});
                throw new ExcelAppException("jp.ecuacion.util.poi.excel.ExcelWriteUtil.WorkbookNotFoundException.message", args).cell(cell).cause(ex);
            }
            ExcelWriteUtil.throwExceptionForUnknownException(ex, cell, fileInfo);
        }
        catch (Exception ex) {
            ExcelWriteUtil.throwExceptionForUnknownException(ex, cell, fileInfo);
        }
    }

    private static void throwExceptionForUnknownException(Exception ex, Cell cell, String fileInfo) throws ExcelAppException {
        StringBuilder sb = new StringBuilder();
        ExceptionUtil.getExceptionListWithMessages((Throwable)ex).stream().forEach(e -> sb.append(e.getMessage() + "\n"));
        sb.deleteCharAt(sb.length() - 1);
        PropertyFileUtil.Arg fileInfoArg = ExcelWriteUtil.getFileInfoString(fileInfo);
        PropertyFileUtil.Arg[] args = (PropertyFileUtil.Arg[])ArrayUtils.addAll((Object[])new PropertyFileUtil.Arg[]{fileInfoArg}, (Object[])new PropertyFileUtil.Arg[]{PropertyFileUtil.Arg.string((String)cell.getSheet().getSheetName()), PropertyFileUtil.Arg.string((String)cell.getAddress().formatAsString()), PropertyFileUtil.Arg.string((String)sb.toString())});
        throw new ExcelAppException("jp.ecuacion.util.poi.excel.ExcelWriteUtil.DetailUnknown.message", args).cell(cell).cause(ex);
    }

    private static PropertyFileUtil.Arg getFileInfoString(String fileInfo) {
        String infoNone = "jp.ecuacion.util.poi.excel.ExcelWriteUtil.FileInfoLabel.None.message";
        PropertyFileUtil.Arg fileInfoLabel = fileInfo == null ? PropertyFileUtil.Arg.message((String)infoNone, (PropertyFileUtil.Arg[])new PropertyFileUtil.Arg[0]) : PropertyFileUtil.Arg.string((String)fileInfo);
        return fileInfoLabel;
    }
}

