/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.util.poi.excel.table.reader;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Min;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.unchecked.UncheckedAppException;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.lib.core.util.ValidationUtil;
import jp.ecuacion.util.poi.excel.exception.ExcelAppException;
import jp.ecuacion.util.poi.excel.exception.LoopBreakException;
import jp.ecuacion.util.poi.excel.table.ExcelTable;
import jp.ecuacion.util.poi.excel.table.reader.IfExcelTableReader;
import jp.ecuacion.util.poi.excel.util.ExcelReadUtil;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class ExcelTableReader<T>
extends ExcelTable<T>
implements IfExcelTableReader<T> {
    private DetailLogger detailLog = new DetailLogger((Object)this);
    protected ExcelReadUtil readUtil = new ExcelReadUtil();
    @Min(value=1L)
    protected @Min(value=1L) Integer tableRowSizeGivenByConstructor;
    @Min(value=1L)
    protected @Min(value=1L) Integer tableColumnSizeGivenByConstructor;

    public ExcelTableReader(@RequireNonnull String sheetName, @Nullable Integer tableStartRowNumber, int tableStartColumnNumber, @Nullable Integer tableRowSize, @Nullable Integer tableColumnSize) {
        super(sheetName, tableStartRowNumber, tableStartColumnNumber);
        this.tableRowSizeGivenByConstructor = tableRowSize;
        this.tableColumnSizeGivenByConstructor = tableColumnSize;
        Set violationSet = ValidationUtil.validate((Object)this);
        if (violationSet != null && violationSet.size() > 0) {
            throw new RuntimeException("Validation failed at TableReader constructor.");
        }
    }

    @Nonnull
    public List<List<T>> read(@RequireNonnull String filePath) throws EncryptedDocumentException, AppException, IOException {
        ObjectsUtil.paramRequireNonNull((Object)filePath);
        try (Workbook excel = this.readUtil.openForRead(filePath);){
            List<List<T>> list = this.read(excel);
            return list;
        }
    }

    @Nonnull
    public List<List<T>> read(@RequireNonnull Workbook workbook) throws EncryptedDocumentException, AppException, IOException {
        List<List<T>> headerData = this.readTableData(workbook, true);
        this.validateHeaderData(headerData);
        List<List<T>> rtnData = this.readTableData(workbook);
        this.updateAndGetHeaderData(rtnData);
        return rtnData;
    }

    @Nonnull
    public Iterable<List<T>> getIterable(@RequireNonnull Workbook workbook) throws EncryptedDocumentException, AppException, IOException {
        List<List<T>> headerData = this.readTableData(workbook, true);
        this.validateHeaderData(headerData);
        List<List<T>> rtnData = this.readTableData(workbook);
        this.updateAndGetHeaderData(rtnData);
        ExcelTable.ContextContainer context = this.readUtil.getReadyToReadTableData(this, workbook, this.getSheetName(), this.tableStartColumnNumber, null, false);
        return new IterableReader(this, context, this.getNumberOfHeaderLines());
    }

    private List<List<T>> readTableData(Workbook workbook) throws AppException {
        return this.readTableData(workbook, false);
    }

    @Nonnull
    private List<List<T>> readTableData(@RequireNonnull Workbook workbook, boolean readsHeaderOnly) throws AppException {
        ExcelTable.ContextContainer context = this.readUtil.getReadyToReadTableData(this, workbook, this.getSheetName(), this.tableStartColumnNumber, readsHeaderOnly ? Integer.valueOf(this.getNumberOfHeaderLines()) : null, readsHeaderOnly);
        ArrayList<List<T>> rowList = new ArrayList<List<T>>();
        try {
            for (int rowNumber = context.poiBasisTableStartRowNumber; rowNumber <= 10000; ++rowNumber) {
                List colList = this.readUtil.readTableLine(this, context, rowNumber);
                rowList.add(colList);
            }
        }
        catch (LoopBreakException loopBreakException) {
            // empty catch block
        }
        this.detailLog.debug("finishing to read excel file. sheet name :" + this.getSheetName());
        this.detailLog.debug("===============");
        return rowList;
    }

    @Nullable
    public Integer getTableRowSize() {
        return this.tableRowSizeGivenByConstructor;
    }

    @Nonnull
    public Integer getTableColumnSize(@RequireNonnull Sheet sheet, int poiBasisDeterminedTableStartRowNumber, int poiBasisDeterminedTableStartColumnNumber, boolean ignoresColumnSizeSetInReader) throws ExcelAppException {
        int size;
        ObjectsUtil.paramRequireNonNull((Object)sheet);
        if (this.tableColumnSizeGivenByConstructor != null && !ignoresColumnSizeSetInReader) {
            return this.tableColumnSizeGivenByConstructor;
        }
        int columnNumber = poiBasisDeterminedTableStartColumnNumber;
        while (true) {
            Cell cell;
            if (this.isVerticalAndHorizontalOpposite) {
                row = sheet.getRow(columnNumber);
                if (row == null || row.getCell(poiBasisDeterminedTableStartRowNumber) == null) break;
                cell = row.getCell(poiBasisDeterminedTableStartRowNumber);
            } else {
                row = sheet.getRow(poiBasisDeterminedTableStartRowNumber);
                if (row == null || row.getCell(columnNumber) == null) break;
                cell = row.getCell(columnNumber);
            }
            if (this.isCellDataEmpty(this.getCellData(cell, this.tableStartColumnNumber + columnNumber + 1))) break;
            ++columnNumber;
        }
        if ((size = columnNumber - poiBasisDeterminedTableStartColumnNumber) == 0) {
            throw new ExcelAppException("jp.ecuacion.util.poi.excel.reader.ColumnSizeIsZero.message", sheet.getSheetName(), Integer.toString(poiBasisDeterminedTableStartRowNumber + 1), Integer.toString(poiBasisDeterminedTableStartColumnNumber + 1)).sheet(sheet);
        }
        return size;
    }

    public void setTableColumnSize(int tableColumnSize) {
        this.tableColumnSizeGivenByConstructor = tableColumnSize;
    }

    @Override
    public ExcelReadUtil getExcelReadUtil() {
        return this.readUtil;
    }

    public ExcelTableReader<T> suppressesWarnLog(boolean suppressesWarnLog) {
        this.readUtil.suppressesWarnLog(suppressesWarnLog);
        return this;
    }

    @Override
    public ExcelTableReader<T> ignoresAdditionalColumnsOfHeaderData(boolean value) {
        this.ignoresAdditionalColumnsOfHeaderData = value;
        return this;
    }

    @Override
    public ExcelTableReader<T> isVerticalAndHorizontalOpposite(boolean value) {
        this.isVerticalAndHorizontalOpposite = value;
        return this;
    }

    public static class IterableReader<T>
    implements Iterable<List<T>> {
        private IteratorReader<T> iterator;

        public IterableReader(ExcelTableReader<T> reader, ExcelTable.ContextContainer context, int numberOfheaderLines) {
            this.iterator = new IteratorReader<T>(reader, context, numberOfheaderLines);
        }

        @Override
        public Iterator<List<T>> iterator() {
            return this.iterator;
        }
    }

    public static class IteratorReader<T>
    implements Iterator<List<T>> {
        private ExcelTableReader<T> reader;
        private ExcelTable.ContextContainer context;
        private boolean hasNext = true;
        private int rowNumber;
        private ExcelReadUtil readUtil = new ExcelReadUtil();

        public IteratorReader(ExcelTableReader<T> reader, ExcelTable.ContextContainer context, int numberOfheaderLines) {
            this.reader = reader;
            this.context = context;
            this.rowNumber = context.poiBasisTableStartRowNumber + numberOfheaderLines;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public List<T> next() {
            List<T> rtn = null;
            try {
                rtn = this.readUtil.readTableLine(this.reader, this.context, this.rowNumber);
                ++this.rowNumber;
                try {
                    this.readUtil.readTableLine(this.reader, this.context, this.rowNumber);
                }
                catch (LoopBreakException ex) {
                    this.hasNext = false;
                }
                return rtn;
            }
            catch (ExcelAppException ex) {
                throw new UncheckedAppException((AppException)ex);
            }
        }
    }
}

