/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.util.poi.excel.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.List;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.lib.core.util.ExceptionUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import jp.ecuacion.util.poi.excel.table.ExcelTable;
import jp.ecuacion.util.poi.excel.table.IfFormatOneLineHeaderExcelTable;
import jp.ecuacion.util.poi.excel.table.writer.ExcelTableWriter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ss.formula.CollaboratingWorkbooksEnvironment;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.formula.eval.NotImplementedException;
import org.apache.poi.ss.formula.eval.NotImplementedFunctionException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelWriteUtil {
    private DetailLogger detailLog = new DetailLogger((Object)this);
    private ExceptionUtil exUtil = new ExceptionUtil();

    public Workbook createWorkbookWithSheet(String sheetName) {
        XSSFWorkbook wb = new XSSFWorkbook();
        wb.createSheet(sheetName);
        return wb;
    }

    public Workbook openForWrite(String filePath) throws EncryptedDocumentException, IOException {
        return WorkbookFactory.create((InputStream)new FileInputStream(filePath));
    }

    public FileOutputStream openForOutput(String filePath) throws EncryptedDocumentException, IOException {
        return new FileOutputStream(filePath);
    }

    public void saveToFile(Workbook workbook, FileOutputStream out) throws EncryptedDocumentException, IOException {
        workbook.write((OutputStream)out);
    }

    public <T> ExcelTable.ContextContainer getReadyToWriteTableData(ExcelTableWriter<T> writer, Workbook workbook, String sheetName, int tableStartColumnNumber) throws BizLogicAppException {
        this.detailLog.debug("===============");
        this.detailLog.debug("starting to write excel file.");
        this.detailLog.debug("sheet name :" + sheetName);
        Sheet sheet = workbook.getSheet(sheetName);
        if (sheet == null) {
            throw new BizLogicAppException("jp.ecuacion.util.poi.excel.SheetNotExist.message", new String[]{sheetName});
        }
        int poiBasisTableStartColumnNumber = writer.getPoiBasisDeterminedTableStartColumnNumber();
        int poiBasisTableStartRowNumber = writer.getPoiBasisDeterminedTableStartRowNumber(sheet, tableStartColumnNumber);
        if (this instanceof IfFormatOneLineHeaderExcelTable) {
            ++poiBasisTableStartRowNumber;
        }
        return new ExcelTable.ContextContainer(sheet, poiBasisTableStartRowNumber, poiBasisTableStartColumnNumber, null, null);
    }

    public <T> void writeTableLine(ExcelTableWriter<T> writer, ExcelTable.ContextContainer context, int rowNumber, List<T> columnList) {
        if (context.sheet.getRow(rowNumber) == null) {
            context.sheet.createRow(rowNumber);
        }
        for (int colNumber = context.poiBasisTableStartColumnNumber; colNumber < context.poiBasisTableStartColumnNumber + columnList.size(); ++colNumber) {
            Cell destCell;
            if (writer.isVerticalAndHorizontalOpposite()) {
                row = context.sheet.getRow(colNumber);
                if (row == null) {
                    row = context.sheet.createRow(colNumber);
                }
                if (row.getCell(rowNumber) == null) {
                    row.createCell(rowNumber);
                }
                destCell = row.getCell(rowNumber);
            } else {
                row = context.sheet.getRow(rowNumber);
                if (row == null) {
                    row = context.sheet.createRow(rowNumber);
                }
                if (row.getCell(colNumber) == null) {
                    row.createCell(colNumber);
                }
                destCell = row.getCell(colNumber);
            }
            T sourceCellData = columnList.get(colNumber - context.poiBasisTableStartColumnNumber);
            writer.writeToCell(colNumber - context.poiBasisTableStartColumnNumber, sourceCellData, destCell);
        }
    }

    public void getReadyToEvaluateFormula(Cell cell, boolean changesNumberString, boolean changesDateString, boolean changesCellsWithTextDataFormat, String[] dateFormats) {
        boolean skipsBecauseOfDataFormat;
        boolean bl = skipsBecauseOfDataFormat = !changesCellsWithTextDataFormat && cell.getCellStyle().getDataFormat() == 49;
        if (cell != null && cell.getCellType() == CellType.STRING && !skipsBecauseOfDataFormat) {
            if (changesNumberString) {
                try {
                    Double d = Double.parseDouble(cell.getStringCellValue().replaceAll(",", ""));
                    cell.setCellValue(d.doubleValue());
                }
                catch (Exception ex) {
                    this.detailLog.trace("String does not match the number format.");
                }
            }
            if (changesDateString) {
                for (String dateFormat : dateFormats) {
                    try {
                        LocalDate locDate = LocalDate.parse(cell.getStringCellValue(), DateTimeFormatter.ofPattern(dateFormat));
                        cell.setCellValue(DateUtil.getExcelDate((LocalDate)locDate));
                        break;
                    }
                    catch (Exception ex) {
                        this.detailLog.trace("String does not match the number format.");
                    }
                }
            }
        }
    }

    public void evaluateFormula(Workbook workbook, String fileInfo) throws BizLogicAppException {
        Iterator sheetIt = workbook.sheetIterator();
        while (sheetIt.hasNext()) {
            Sheet sheet = (Sheet)sheetIt.next();
            Iterator rowIt = sheet.rowIterator();
            while (rowIt.hasNext()) {
                Row row = (Row)rowIt.next();
                Iterator cellIt = row.cellIterator();
                while (cellIt.hasNext()) {
                    Cell cell = (Cell)cellIt.next();
                    this.evaluateFormula(cell, fileInfo);
                }
            }
        }
    }

    public void evaluateFormula(Workbook workbook, String fileInfo, String ... sheetNames) throws BizLogicAppException {
        for (String sheetName : sheetNames) {
            Sheet sheet = workbook.getSheet(sheetName);
            Iterator rowIt = sheet.rowIterator();
            while (rowIt.hasNext()) {
                Row row = (Row)rowIt.next();
                Iterator cellIt = row.cellIterator();
                while (cellIt.hasNext()) {
                    Cell cell = (Cell)cellIt.next();
                    this.evaluateFormula(cell, fileInfo);
                }
            }
        }
    }

    public void evaluateFormula(Cell cell, String fileInfo) throws BizLogicAppException {
        PropertyFileUtil.Arg fileInfoArg = this.getFileInfoString(fileInfo);
        Workbook workbook = cell.getRow().getSheet().getWorkbook();
        try {
            workbook.getCreationHelper().createFormulaEvaluator().evaluateFormulaCell(cell);
        }
        catch (NotImplementedException ex) {
            String sheetAndCell = ex.getMessage().replace("Error evaluating cell ", "");
            String sheet = sheetAndCell.split("!")[0];
            String tmpCell = sheetAndCell.split("!")[1];
            PropertyFileUtil.Arg reason = PropertyFileUtil.Arg.message((String)"jp.ecuacion.util.poi.excel.ExcelWriteUtil.NotImplementedException.ReasonUnknown.message", (PropertyFileUtil.Arg[])new PropertyFileUtil.Arg[0]);
            if (ex.getCause() instanceof NotImplementedFunctionException) {
                NotImplementedFunctionException ex2 = (NotImplementedFunctionException)ex.getCause();
                String msg = "jp.ecuacion.util.poi.excel.ExcelWriteUtil.NotImplementedException.ReasonUnimplementedFunction.message";
                reason = PropertyFileUtil.Arg.message((String)msg, (PropertyFileUtil.Arg[])new PropertyFileUtil.Arg[]{PropertyFileUtil.Arg.string((String)ex2.getMessage().replace("_xlfn.", ""))});
            }
            throw new BizLogicAppException("jp.ecuacion.util.poi.excel.ExcelWriteUtil.NotImplementedException.message", (PropertyFileUtil.Arg[])ArrayUtils.addAll((Object[])((PropertyFileUtil.Arg[])ArrayUtils.addAll((Object[])PropertyFileUtil.Arg.strings((String[])new String[]{sheet, tmpCell}), (Object[])new PropertyFileUtil.Arg[]{reason})), (Object[])new PropertyFileUtil.Arg[]{fileInfoArg}));
        }
        catch (FormulaParseException ex) {
            this.throwBizLogicExceptionForUnknownException((Exception)((Object)ex), cell, fileInfo);
        }
        catch (IllegalStateException ex) {
            String msg1 = ex.getMessage();
            String startsWith1 = "Failed to evaluate cell: ";
            if (!msg1.startsWith(startsWith1)) {
                this.throwBizLogicExceptionForUnknownException(ex, cell, fileInfo);
            }
            String[] arg1Tmp1Arr = msg1.replace(startsWith1, "").split(",");
            String sheetame = arg1Tmp1Arr[0].split("!")[0];
            String cellName = arg1Tmp1Arr[0].split("!")[1];
            String errorOccuredFunction = arg1Tmp1Arr[1].replace("value: ", "");
            if (ex.getCause() != null && ex.getCause() instanceof IllegalStateException) {
                IllegalStateException ex2 = (IllegalStateException)ex.getCause();
                if (ex2.getCause() != null && ex2.getCause() instanceof CollaboratingWorkbooksEnvironment.WorkbookNotFoundException) {
                    CollaboratingWorkbooksEnvironment.WorkbookNotFoundException ex3 = (CollaboratingWorkbooksEnvironment.WorkbookNotFoundException)ex2.getCause();
                    String startsWith = "Could not resolve external workbook name ";
                    if (ex3.getMessage().startsWith(startsWith)) {
                        String arg3Tmp1 = ex3.getMessage().replace(startsWith + "'", "");
                        String fileInfoInFunction = arg3Tmp1.substring(0, arg3Tmp1.indexOf("'"));
                        throw new BizLogicAppException("jp.ecuacion.util.poi.excel.ExcelWriteUtil.WorkbookNotFoundException.message", (PropertyFileUtil.Arg[])ArrayUtils.addAll((Object[])PropertyFileUtil.Arg.strings((String[])new String[]{sheetame, cellName, errorOccuredFunction, fileInfoInFunction}), (Object[])new PropertyFileUtil.Arg[]{fileInfoArg}));
                    }
                    this.throwBizLogicExceptionForIllegalStateExceptionFailedToEvaluateCell((Exception)ex3, fileInfo, sheetame, cellName, errorOccuredFunction);
                } else {
                    this.throwBizLogicExceptionForIllegalStateExceptionFailedToEvaluateCell(ex2, fileInfo, sheetame, cellName, errorOccuredFunction);
                }
            } else {
                this.throwBizLogicExceptionForIllegalStateExceptionFailedToEvaluateCell(ex, fileInfo, sheetame, cellName, errorOccuredFunction);
            }
        }
        catch (Exception ex) {
            this.throwBizLogicExceptionForUnknownException(ex, cell, fileInfo);
        }
    }

    private void throwBizLogicExceptionForUnknownException(Exception ex, Cell cell, String fileInfo) throws BizLogicAppException {
        StringBuilder sb = new StringBuilder();
        this.exUtil.getExceptionListWithMessages((Throwable)ex).stream().forEach(e -> sb.append(e.getMessage() + "\n"));
        sb.deleteCharAt(sb.length() - 1);
        PropertyFileUtil.Arg fileInfoArg = this.getFileInfoString(fileInfo);
        throw new BizLogicAppException("jp.ecuacion.util.poi.excel.ExcelWriteUtil.DetailUnknown.message", (PropertyFileUtil.Arg[])ArrayUtils.addAll((Object[])new PropertyFileUtil.Arg[]{fileInfoArg}, (Object[])new PropertyFileUtil.Arg[]{PropertyFileUtil.Arg.string((String)cell.getSheet().getSheetName()), PropertyFileUtil.Arg.string((String)cell.getAddress().formatAsString()), PropertyFileUtil.Arg.string((String)sb.toString())}));
    }

    private void throwBizLogicExceptionForIllegalStateExceptionFailedToEvaluateCell(Exception ex, String fileInfo, String sheetName, String cellName, String errorOccuredFunction) throws BizLogicAppException {
        StringBuilder sb = new StringBuilder();
        this.exUtil.getExceptionListWithMessages((Throwable)ex).stream().forEach(e -> sb.append(e.getMessage() + "\n"));
        sb.deleteCharAt(sb.length() - 1);
        PropertyFileUtil.Arg fileInfoArg = this.getFileInfoString(fileInfo);
        throw new BizLogicAppException("jp.ecuacion.util.poi.excel.ExcelWriteUtil.DetailUnknown.message", (PropertyFileUtil.Arg[])ArrayUtils.addAll((Object[])((PropertyFileUtil.Arg[])ArrayUtils.addAll((Object[])PropertyFileUtil.Arg.strings((String[])new String[]{sheetName, cellName, errorOccuredFunction}), (Object[])new PropertyFileUtil.Arg[]{fileInfoArg})), (Object[])PropertyFileUtil.Arg.strings((String[])new String[]{sb.toString()})));
    }

    private PropertyFileUtil.Arg getFileInfoString(String fileInfo) {
        String infoNone = "jp.ecuacion.util.poi.excel.ExcelWriteUtil.FileInfoLabel.None.message";
        PropertyFileUtil.Arg fileInfoLabel = fileInfo == null ? PropertyFileUtil.Arg.message((String)infoNone, (PropertyFileUtil.Arg[])new PropertyFileUtil.Arg[0]) : PropertyFileUtil.Arg.string((String)fileInfo);
        return fileInfoLabel;
    }
}

