/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.util.poi.excel.table.reader.concrete;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import jp.ecuacion.lib.core.util.ValidationUtil;
import jp.ecuacion.util.poi.excel.enums.NoDataString;
import jp.ecuacion.util.poi.excel.table.bean.StringExcelTableBean;
import jp.ecuacion.util.poi.excel.table.reader.concrete.StringOneLineHeaderExcelTableReader;
import org.apache.poi.EncryptedDocumentException;

public class StringOneLineHeaderExcelTableToBeanReader<T extends StringExcelTableBean>
extends StringOneLineHeaderExcelTableReader {
    private Class<?> beanClass;

    public StringOneLineHeaderExcelTableToBeanReader(Class<?> beanClass, @RequireNonnull String sheetName, @RequireNonnull String[] headerLabels, Integer tableStartRowNumber, int tableStartColumnNumber, Integer tableRowSize, T ... parameterClass) {
        super(sheetName, headerLabels, tableStartRowNumber, tableStartColumnNumber, tableRowSize);
        this.beanClass = beanClass;
    }

    public StringOneLineHeaderExcelTableToBeanReader(Class<?> beanClass, @RequireNonnull String sheetName, @RequireNonnull String[] headerLabels, Integer tableStartRowNumber, int tableStartColumnNumber, Integer tableRowSize, @Nonnull NoDataString noDataString) {
        super(sheetName, headerLabels, tableStartRowNumber, tableStartColumnNumber, tableRowSize, noDataString);
        this.beanClass = beanClass;
    }

    public List<T> readToBean(String filePath) throws AppException, EncryptedDocumentException, IOException {
        return this.readToBean(filePath, true);
    }

    public List<T> readToBean(String filePath, boolean validates) throws AppException, EncryptedDocumentException, IOException {
        String msgId = "jp.ecuacion.util.poi.excel.reader.ValidationMessagePostfix.message";
        List<T> rtnList = this.excelTableToBeanList(filePath);
        ValidationUtil valUtil = new ValidationUtil();
        if (validates) {
            for (StringExcelTableBean bean : rtnList) {
                valUtil.setMessageWithItemName(true).setMessagePostfix(PropertyFileUtil.Arg.message((String)"jp.ecuacion.util.poi.excel.reader.ValidationMessagePostfix.message", (PropertyFileUtil.Arg[])PropertyFileUtil.Arg.strings((String[])new String[]{this.sheetName}))).validateThenThrow((Object)bean);
                bean.afterReading();
            }
        }
        return rtnList;
    }

    protected List<T> excelTableToBeanList(String filePath) throws AppException, IOException {
        List lines = this.read(filePath);
        ArrayList<StringExcelTableBean> rtnList = new ArrayList<StringExcelTableBean>();
        for (List line : lines) {
            try {
                StringExcelTableBean bean = (StringExcelTableBean)this.beanClass.getConstructor(List.class).newInstance(line);
                rtnList.add(bean);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return rtnList;
    }

    @Override
    public StringOneLineHeaderExcelTableToBeanReader<T> defaultDateTimeFormat(DateTimeFormatter dateTimeFormat) {
        return (StringOneLineHeaderExcelTableToBeanReader)super.defaultDateTimeFormat(dateTimeFormat);
    }

    @Override
    public StringOneLineHeaderExcelTableToBeanReader<T> columnDateTimeFormat(int columnNumber, DateTimeFormatter dateTimeFormat) {
        return (StringOneLineHeaderExcelTableToBeanReader)super.columnDateTimeFormat(columnNumber, dateTimeFormat);
    }

    @Override
    public StringOneLineHeaderExcelTableToBeanReader<T> suppressesWarnLog(boolean suppressesWarnLog) {
        super.suppressesWarnLog(suppressesWarnLog);
        return this;
    }

    @Override
    public StringOneLineHeaderExcelTableToBeanReader<T> ignoresAdditionalColumnsOfHeaderData(boolean value) {
        this.ignoresAdditionalColumnsOfHeaderData = value;
        return this;
    }
}

