/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.util.poi.excel.table.writer.concrete;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.util.poi.excel.table.IfFormatOneLineHeaderExcelTable;
import jp.ecuacion.util.poi.excel.table.reader.ExcelTableReader;
import jp.ecuacion.util.poi.excel.table.reader.concrete.StringOneLineHeaderExcelTableReader;
import jp.ecuacion.util.poi.excel.table.writer.ExcelTableWriter;
import jp.ecuacion.util.poi.excel.table.writer.IfDataTypeCellExcelTableWriter;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;

public class CellOneLineHeaderExcelTableWriter
extends ExcelTableWriter<Cell>
implements IfDataTypeCellExcelTableWriter,
IfFormatOneLineHeaderExcelTable<Cell> {
    @Nonnull
    private String[] headerLabels;
    private Map<Integer, CellStyle> columnStyleMap = new HashMap<Integer, CellStyle>();

    public CellOneLineHeaderExcelTableWriter(@RequireNonnull String sheetName, @RequireNonnull String[] headerLabels, @Nullable Integer tableStartRowNumber, int tableStartColumnNumber) {
        super(sheetName, tableStartRowNumber, tableStartColumnNumber);
        this.headerLabels = (String[])ObjectsUtil.paramRequireNonNull((Object)headerLabels);
    }

    @Override
    @Nonnull
    public String[] getHeaderLabels() {
        return this.headerLabels;
    }

    @Override
    protected void headerCheck(@RequireNonnull Workbook workbook) throws EncryptedDocumentException, AppException, IOException {
        ((ExcelTableReader)new StringOneLineHeaderExcelTableReader(this.getSheetName(), this.getHeaderLabelData()[0], this.tableStartRowNumber, this.tableStartColumnNumber, (Integer)1).ignoresAdditionalColumnsOfHeaderData(this.ignoresAdditionalColumnsOfHeaderData())).read(workbook);
    }

    @Override
    public Map<Integer, CellStyle> getColumnStyleMap() {
        return this.columnStyleMap;
    }
}

