/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.util.poi.excel.table;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.util.ObjectsUtil;

public interface IfExcelTable<T> {
    @Nonnull
    public String getSheetName();

    public int getNumberOfHeaderLines();

    @Nonnull
    public String getFarLeftAndTopHeaderLabel();

    @Nonnull
    public String[][] getHeaderLabelData();

    public IfExcelTable<T> ignoresAdditionalColumnsOfHeaderData(boolean var1);

    public boolean ignoresAdditionalColumnsOfHeaderData();

    default public void validateHeaderData(@RequireNonnull List<List<T>> headerData) throws BizLogicAppException {
        for (int i = 0; i < ((List)ObjectsUtil.paramRequireNonNull(headerData)).size(); ++i) {
            List<T> headerList = headerData.get(i);
            String[] headerLabels = this.getHeaderLabelData()[i];
            boolean ignoresAdditionalColumns = this.ignoresAdditionalColumnsOfHeaderData();
            if (!ignoresAdditionalColumns && headerList.size() != headerLabels.length || ignoresAdditionalColumns && headerList.size() < headerLabels.length) {
                throw new BizLogicAppException("jp.ecuacion.util.poi.excel.NumberOfTableHeadersDiffer.message", new String[]{this.getSheetName(), Integer.toString(headerList.size()), Integer.toString(headerLabels.length)});
            }
            for (int j = 0; j < headerLabels.length; ++j) {
                if (headerLabels[j].equals(this.getStringValue(headerList.get(j)))) continue;
                int positionFromUser = j + 1;
                throw new BizLogicAppException("jp.ecuacion.util.poi.excel.TableHeaderTitleWrong.message", new String[]{this.getSheetName(), Integer.toString(positionFromUser), this.getStringValue(headerList.get(j)), headerLabels[j]});
            }
        }
    }

    @Nullable
    public String getStringValue(@Nullable T var1) throws BizLogicAppException;
}

