/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.util.poi.excel.table.writer;

import java.util.Map;
import jp.ecuacion.util.poi.excel.table.IfDataTypeCellExcelTable;
import jp.ecuacion.util.poi.excel.table.writer.IfExcelTableWriter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellCopyPolicy;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.util.CellUtil;

public interface IfDataTypeCellExcelTableWriter
extends IfDataTypeCellExcelTable,
IfExcelTableWriter<Cell> {
    @Override
    default public void writeToCell(int columnNumberFromZero, Cell sourceCellData, Cell destCell) {
        this.writeToCell(columnNumberFromZero, sourceCellData, destCell, false);
    }

    default public void writeToCell(int columnNumberFromZero, Cell sourceCellData, Cell destCell, boolean copiesStyleOfDataFormatOnly) {
        CellCopyPolicy policy = new CellCopyPolicy();
        policy.setCopyCellFormula(false);
        policy.setCopyCellStyle(false);
        CellUtil.copyCell((Cell)sourceCellData, (Cell)destCell, (CellCopyPolicy)policy, null);
        if (this.getColumnStyleMap().containsKey(columnNumberFromZero)) {
            destCell.setCellStyle(this.getColumnStyleMap().get(columnNumberFromZero));
        } else if (copiesStyleOfDataFormatOnly) {
            destCell.getCellStyle().setDataFormat(sourceCellData.getCellStyle().getDataFormat());
        } else {
            destCell.setCellStyle(destCell.getRow().getSheet().getWorkbook().createCellStyle());
            destCell.getCellStyle().cloneStyleFrom(sourceCellData.getCellStyle());
            this.getColumnStyleMap().put(columnNumberFromZero, destCell.getCellStyle());
        }
    }

    public Map<Integer, CellStyle> getColumnStyleMap();
}

