/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.util.poi.excel.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.lib.core.util.ExceptionUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import jp.ecuacion.util.poi.excel.table.ExcelTable;
import jp.ecuacion.util.poi.excel.table.IfFormatOneLineHeaderExcelTable;
import jp.ecuacion.util.poi.excel.table.writer.ExcelTableWriter;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ss.formula.CollaboratingWorkbooksEnvironment;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.formula.eval.NotImplementedException;
import org.apache.poi.ss.formula.eval.NotImplementedFunctionException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelWriteUtil {
    private DetailLogger detailLog = new DetailLogger((Object)this);
    private ExceptionUtil exUtil = new ExceptionUtil();

    public Workbook createWorkbookWithSheet(String sheetName) {
        XSSFWorkbook wb = new XSSFWorkbook();
        wb.createSheet(sheetName);
        return wb;
    }

    public Workbook openForWrite(String filePath) throws EncryptedDocumentException, IOException {
        return WorkbookFactory.create((InputStream)new FileInputStream(filePath));
    }

    public FileOutputStream openForOutput(String filePath) throws EncryptedDocumentException, IOException {
        return new FileOutputStream(filePath);
    }

    public void saveToFile(Workbook workbook, FileOutputStream out) throws EncryptedDocumentException, IOException {
        workbook.write((OutputStream)out);
    }

    public <T> ExcelTable.ContextContainer getReadyToWriteTableData(ExcelTableWriter<T> writer, Workbook workbook, String sheetName) throws BizLogicAppException {
        this.detailLog.debug("===============");
        this.detailLog.debug("starting to write excel file.");
        this.detailLog.debug("sheet name :" + sheetName);
        Sheet sheet = workbook.getSheet(sheetName);
        if (sheet == null) {
            throw new BizLogicAppException("jp.ecuacion.util.poi.excel.SheetNotExist.message", new String[]{sheetName});
        }
        int poiBasisTableStartColumnNumber = writer.getPoiBasisDeterminedTableStartColumnNumber();
        int poiBasisTableStartRowNumber = writer.getPoiBasisDeterminedTableStartRowNumber(sheet);
        if (this instanceof IfFormatOneLineHeaderExcelTable) {
            ++poiBasisTableStartRowNumber;
        }
        return new ExcelTable.ContextContainer(sheet, poiBasisTableStartRowNumber, poiBasisTableStartColumnNumber, null, null);
    }

    public <T> void writeTableLine(ExcelTableWriter<T> writer, ExcelTable.ContextContainer context, int rowNumber, List<T> columnList) {
        if (context.sheet.getRow(rowNumber) == null) {
            context.sheet.createRow(rowNumber);
        }
        Row row = context.sheet.getRow(rowNumber);
        for (int colNumber = context.poiBasisTableStartColumnNumber; colNumber < context.poiBasisTableStartColumnNumber + columnList.size(); ++colNumber) {
            T sourceCellData = columnList.get(colNumber - context.poiBasisTableStartColumnNumber);
            if (row.getCell(colNumber) == null) {
                row.createCell(colNumber);
            }
            Cell destCell = row.getCell(colNumber);
            writer.writeToCell(colNumber - context.poiBasisTableStartColumnNumber, sourceCellData, destCell);
        }
    }

    public void evaluateAllFormulas(Workbook workbook) throws BizLogicAppException {
        this.evaluateAllFormulas(workbook, null);
    }

    public void evaluateAllFormulas(Workbook workbook, String fileInfo) throws BizLogicAppException {
        try {
            workbook.getCreationHelper().createFormulaEvaluator().evaluateAll();
        }
        catch (NotImplementedException ex) {
            String sheetAndCell = ex.getMessage().replace("Error evaluating cell ", "");
            String sheet = sheetAndCell.split("!")[0];
            String cell = sheetAndCell.split("!")[1];
            Object reason = PropertyFileUtil.getMsg((String)"jp.ecuacion.util.poi.excel.ExcelWriteUtil.NotImplementedException.ReasonUnknown.message", (String[])new String[0]);
            if (ex.getCause() instanceof NotImplementedFunctionException) {
                NotImplementedFunctionException ex2 = (NotImplementedFunctionException)ex.getCause();
                reason = "\u672a\u5bfe\u5fdc\u306e\u95a2\u6570\uff1a" + ex2.getMessage().replace("_xlfn.", "");
            }
            throw new BizLogicAppException("jp.ecuacion.util.poi.excel.ExcelWriteUtil.NotImplementedException.message", new String[]{sheet, cell, reason});
        }
        catch (FormulaParseException ex) {
            this.throwBizLogicExceptionForUnknownException((Exception)((Object)ex), fileInfo);
        }
        catch (IllegalStateException ex) {
            String msg1 = ex.getMessage();
            String startsWith1 = "Failed to evaluate cell: ";
            if (!msg1.startsWith(startsWith1)) {
                this.throwBizLogicExceptionForUnknownException(ex, fileInfo);
            }
            String[] arg1Tmp1Arr = msg1.replace(startsWith1, "").split(",");
            String sheetame = arg1Tmp1Arr[0].split("!")[0];
            String cellName = arg1Tmp1Arr[0].split("!")[1];
            String errorOccuredFunction = arg1Tmp1Arr[1].replace("value: ", "");
            if (ex.getCause() != null && ex.getCause() instanceof IllegalStateException) {
                IllegalStateException ex2 = (IllegalStateException)ex.getCause();
                if (ex2.getCause() != null && ex2.getCause() instanceof CollaboratingWorkbooksEnvironment.WorkbookNotFoundException) {
                    CollaboratingWorkbooksEnvironment.WorkbookNotFoundException ex3 = (CollaboratingWorkbooksEnvironment.WorkbookNotFoundException)ex2.getCause();
                    String startsWith = "Could not resolve external workbook name ";
                    if (ex3.getMessage().startsWith(startsWith)) {
                        String arg3Tmp1 = ex3.getMessage().replace(startsWith + "'", "");
                        String fileInfoInFunction = arg3Tmp1.substring(0, arg3Tmp1.indexOf("'"));
                        PropertyFileUtil.Arg[] fileInfoStrs = this.getFileInfoString(fileInfo, false);
                        throw new BizLogicAppException("jp.ecuacion.util.poi.excel.ExcelWriteUtil.WorkbookNotFoundException.message", new PropertyFileUtil.Arg[]{new PropertyFileUtil.Arg(sheetame), new PropertyFileUtil.Arg(cellName), new PropertyFileUtil.Arg(errorOccuredFunction), new PropertyFileUtil.Arg(fileInfoInFunction), fileInfoStrs[0], fileInfoStrs[1], fileInfoStrs[2], fileInfoStrs[3]});
                    }
                    this.throwBizLogicExceptionForIllegalStateExceptionFailedToEvaluateCell((Exception)ex3, fileInfo, sheetame, cellName, errorOccuredFunction);
                } else {
                    this.throwBizLogicExceptionForIllegalStateExceptionFailedToEvaluateCell(ex2, fileInfo, sheetame, cellName, errorOccuredFunction);
                }
            } else {
                this.throwBizLogicExceptionForIllegalStateExceptionFailedToEvaluateCell(ex, fileInfo, sheetame, cellName, errorOccuredFunction);
            }
        }
        catch (Exception ex) {
            this.throwBizLogicExceptionForUnknownException(ex, fileInfo);
        }
    }

    private void throwBizLogicExceptionForUnknownException(Exception ex, String fileInfo) throws BizLogicAppException {
        StringBuilder sb = new StringBuilder();
        this.exUtil.getExceptionListWithMessages((Throwable)ex).stream().forEach(e -> sb.append("  - " + e.getMessage()));
        PropertyFileUtil.Arg[] fileInfoStrs = this.getFileInfoString(fileInfo, true);
        throw new BizLogicAppException("jp.ecuacion.util.poi.excel.ExcelWriteUtil.DetailUnknown.message", new PropertyFileUtil.Arg[]{fileInfoStrs[0], fileInfoStrs[1], fileInfoStrs[2], fileInfoStrs[3], new PropertyFileUtil.Arg(sb.toString())});
    }

    private void throwBizLogicExceptionForIllegalStateExceptionFailedToEvaluateCell(Exception ex, String fileInfo, String sheetName, String cellName, String errorOccuredFunction) throws BizLogicAppException {
        StringBuilder sb = new StringBuilder();
        this.exUtil.getExceptionListWithMessages((Throwable)ex).stream().forEach(e -> sb.append("  - " + e.getMessage()));
        PropertyFileUtil.Arg[] fileInfoStrs = this.getFileInfoString(fileInfo, false);
        throw new BizLogicAppException("jp.ecuacion.util.poi.excel.ExcelWriteUtil.DetailUnknown.message", new PropertyFileUtil.Arg[]{new PropertyFileUtil.Arg(sheetName), new PropertyFileUtil.Arg(cellName), new PropertyFileUtil.Arg(errorOccuredFunction), fileInfoStrs[0], fileInfoStrs[1], fileInfoStrs[2], fileInfoStrs[3], new PropertyFileUtil.Arg(sb.toString())});
    }

    private PropertyFileUtil.Arg[] getFileInfoString(String fileInfo, boolean is1stParameter) {
        String msgLabel = "jp.ecuacion.util.poi.excel.ExcelWriteUtil.FileInfoLabel.message";
        PropertyFileUtil.Arg prefix = is1stParameter ? new PropertyFileUtil.Arg("jp.ecuacion.util.poi.excel.ExcelWriteUtil.StartBracket.message", true) : new PropertyFileUtil.Arg("jp.ecuacion.util.poi.excel.ExcelWriteUtil.Comma.message", true);
        PropertyFileUtil.Arg fileInfoLabel = fileInfo == null ? new PropertyFileUtil.Arg("") : new PropertyFileUtil.Arg(msgLabel, true);
        PropertyFileUtil.Arg fileInfoValue = fileInfo == null ? new PropertyFileUtil.Arg("") : new PropertyFileUtil.Arg(fileInfo);
        PropertyFileUtil.Arg postfix = new PropertyFileUtil.Arg("jp.ecuacion.util.poi.excel.ExcelWriteUtil.EndBracket.message", true);
        return new PropertyFileUtil.Arg[]{prefix, fileInfoLabel, fileInfoValue, postfix};
    }
}

