/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.util.poi.excel.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.util.poi.excel.table.ExcelTable;
import jp.ecuacion.util.poi.excel.table.IfFormatOneLineHeaderExcelTable;
import jp.ecuacion.util.poi.excel.table.writer.ExcelTableWriter;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelWriteUtil {
    private DetailLogger detailLog = new DetailLogger((Object)this);

    public Workbook createWorkbookWithSheet(String sheetName) {
        XSSFWorkbook wb = new XSSFWorkbook();
        wb.createSheet(sheetName);
        return wb;
    }

    public Workbook openForWrite(String filePath) throws EncryptedDocumentException, IOException {
        return WorkbookFactory.create((InputStream)new FileInputStream(filePath));
    }

    public FileOutputStream openForOutput(String filePath) throws EncryptedDocumentException, IOException {
        return new FileOutputStream(filePath);
    }

    public void saveToFile(Workbook workbook, FileOutputStream out) throws EncryptedDocumentException, IOException {
        workbook.write((OutputStream)out);
    }

    public <T> ExcelTable.ContextContainer getReadyToWriteTableData(ExcelTableWriter<T> writer, Workbook workbook, String sheetName) throws BizLogicAppException {
        this.detailLog.debug("===============");
        this.detailLog.debug("starting to write excel file.");
        this.detailLog.debug("sheet name :" + sheetName);
        Sheet sheet = workbook.getSheet(sheetName);
        if (sheet == null) {
            throw new BizLogicAppException("MSG_ERR_SHEET_NOT_EXIST", new String[]{sheetName});
        }
        int poiBasisTableStartColumnNumber = writer.getPoiBasisDeterminedTableStartColumnNumber();
        int poiBasisTableStartRowNumber = writer.getPoiBasisDeterminedTableStartRowNumber(sheet);
        if (this instanceof IfFormatOneLineHeaderExcelTable) {
            ++poiBasisTableStartRowNumber;
        }
        return new ExcelTable.ContextContainer(sheet, poiBasisTableStartRowNumber, poiBasisTableStartColumnNumber, null, null);
    }

    public <T> void writeTableLine(ExcelTableWriter<T> writer, ExcelTable.ContextContainer context, int rowNumber, List<T> columnList) {
        if (context.sheet.getRow(rowNumber) == null) {
            context.sheet.createRow(rowNumber);
        }
        Row row = context.sheet.getRow(rowNumber);
        for (int colNumber = context.poiBasisTableStartColumnNumber; colNumber < context.poiBasisTableStartColumnNumber + columnList.size(); ++colNumber) {
            T sourceCellData = columnList.get(colNumber - context.poiBasisTableStartColumnNumber);
            if (row.getCell(colNumber) == null) {
                row.createCell(colNumber);
            }
            Cell destCell = row.getCell(colNumber);
            writer.writeToCell(colNumber - context.poiBasisTableStartColumnNumber, sourceCellData, destCell);
        }
    }
}

