/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.util.poi.excel.table;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.util.ObjectsUtil;

public interface IfExcelTable<T> {
    @Nonnull
    public String getSheetName();

    public int getNumberOfHeaderLines();

    @Nonnull
    public String getFarLeftAndTopHeaderLabel();

    @Nonnull
    public String[][] getHeaderLabelData();

    default public void validateHeaderData(@RequireNonnull List<List<String>> headerData) throws BizLogicAppException {
        for (int i = 0; i < ((List)ObjectsUtil.paramRequireNonNull(headerData)).size(); ++i) {
            List<String> headerList = headerData.get(i);
            String[] headerLabels = this.getHeaderLabelData()[i];
            for (int j = 0; j < headerList.size(); ++j) {
                if (headerList.get(j).equals(headerLabels[j])) continue;
                int positionFromUser = j + 1;
                throw new BizLogicAppException("MSG_ERR_HEADER_TITLE_WRONG", new String[]{this.getSheetName(), Integer.toString(positionFromUser), headerList.get(j), headerLabels[j]});
            }
        }
    }

    @Nullable
    public String getStringValue(@Nullable T var1) throws BizLogicAppException;
}

