/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.util.poi.excel.table.writer.concrete;

import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.util.poi.excel.table.IfFormatFreeExcelTable;
import jp.ecuacion.util.poi.excel.table.writer.ExcelTableWriter;
import jp.ecuacion.util.poi.excel.table.writer.IfDataTypeCellExcelTableWriter;
import jp.ecuacion.util.poi.excel.util.ExcelReadUtil;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;

public class CellFreeExcelTableWriter
extends ExcelTableWriter<Cell>
implements IfFormatFreeExcelTable<Cell>,
IfDataTypeCellExcelTableWriter {
    private Map<Integer, CellStyle> columnStyleMap = new HashMap<Integer, CellStyle>();

    public CellFreeExcelTableWriter(@RequireNonnull String sheetName, Integer tableStartRowNumber, int tableStartColumnNumber) {
        super(sheetName, tableStartRowNumber, tableStartColumnNumber);
    }

    @Override
    public String getStringValue(@Nullable Cell cellData) throws BizLogicAppException {
        return new ExcelReadUtil().getStringFromCell(cellData);
    }

    @Override
    protected void headerCheck(@RequireNonnull Workbook workbook) throws EncryptedDocumentException, AppException, IOException {
    }

    @Override
    public Map<Integer, CellStyle> getColumnStyleMap() {
        return this.columnStyleMap;
    }
}

