/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.util.poi.excel.table.writer;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.util.poi.excel.table.ExcelTable;
import jp.ecuacion.util.poi.excel.table.writer.IfExcelTableWriter;
import jp.ecuacion.util.poi.excel.util.ExcelWriteUtil;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class ExcelTableWriter<T>
extends ExcelTable<T>
implements IfExcelTableWriter<T> {
    private ExcelWriteUtil writeUtil = new ExcelWriteUtil();

    public ExcelTableWriter(@RequireNonnull String sheetName, @Nullable Integer tableStartRowNumber, int tableStartColumnNumber) {
        super(sheetName, tableStartRowNumber, tableStartColumnNumber);
    }

    public void write(@RequireNonnull String templateFilePath, @RequireNonnull String destFilePath, @RequireNonnull List<List<T>> data) throws Exception {
        ObjectsUtil.paramRequireNonNull((Object)templateFilePath);
        ObjectsUtil.paramRequireNonNull((Object)destFilePath);
        try (Workbook workbook = this.writeUtil.openForWrite(templateFilePath);
             FileOutputStream out = new FileOutputStream(destFilePath);){
            this.headerCheck(workbook);
            this.writeTableValues(workbook, data);
            workbook.write((OutputStream)out);
        }
    }

    public Workbook write(@RequireNonnull String templateFilePath, @RequireNonnull List<List<T>> data) throws Exception {
        try (Workbook workbook = this.writeUtil.openForWrite(templateFilePath);){
            this.headerCheck(workbook);
            this.writeTableValues(workbook, data);
            Workbook workbook2 = workbook;
            return workbook2;
        }
    }

    public void write(@RequireNonnull Workbook workbook, @RequireNonnull List<List<T>> data) throws Exception {
        this.headerCheck(workbook);
        this.writeTableValues(workbook, data);
    }

    @Nonnull
    public IterableWriter<T> getIterable(@RequireNonnull Workbook workbook) throws EncryptedDocumentException, AppException, IOException {
        this.headerCheck(workbook);
        ExcelTable.ContextContainer context = this.writeUtil.getReadyToWriteTableData(this, workbook, this.getSheetName());
        return new IterableWriter(this, context, this.getNumberOfHeaderLines());
    }

    protected abstract void headerCheck(@RequireNonnull Workbook var1) throws EncryptedDocumentException, AppException, IOException;

    private void writeTableValues(@RequireNonnull Workbook workbook, @RequireNonnull List<List<T>> data) throws FileNotFoundException, IOException, BizLogicAppException {
        ExcelTable.ContextContainer context = this.writeUtil.getReadyToWriteTableData(this, workbook, this.getSheetName());
        for (int rowNumber = context.poiBasisTableStartRowNumber; rowNumber < context.poiBasisTableStartRowNumber + data.size(); ++rowNumber) {
            List<T> list = data.get(rowNumber - context.poiBasisTableStartRowNumber);
            this.writeUtil.writeTableLine(this, context, rowNumber, list);
        }
    }

    @Override
    public ExcelTableWriter<T> ignoresAdditionalColumnsOfHeaderData(boolean value) {
        this.ignoresAdditionalColumnsOfHeaderData = value;
        return this;
    }

    public static class IterableWriter<T> {
        private ExcelTableWriter<T> writer;
        private ExcelTable.ContextContainer context;
        private int rowNumber;
        private ExcelWriteUtil writeUtil = new ExcelWriteUtil();

        public IterableWriter(ExcelTableWriter<T> writer, ExcelTable.ContextContainer context, int numberOfheaderLines) {
            this.writer = writer;
            this.context = context;
            this.rowNumber = context.poiBasisTableStartRowNumber + numberOfheaderLines;
        }

        public void write(List<T> columnList) {
            this.writeUtil.writeTableLine(this.writer, this.context, this.rowNumber, columnList);
            ++this.rowNumber;
        }
    }
}

