/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.util.poi.excel.table.bean;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.logging.DetailLogger;

public abstract class StringExcelTableBean {
    private DetailLogger detailLog = new DetailLogger((Object)this);

    public void afterReading() throws AppException {
    }

    @Nonnull
    protected abstract String[] getFieldNameArray();

    public StringExcelTableBean(@RequireNonnull List<String> colList) {
        String[] fieldNameArray = this.getFieldNameArray();
        if (colList.size() != fieldNameArray.length) {
            throw new RuntimeException("Number of elements in fieldNameArray and colList differ.\nfieldNameArray (" + fieldNameArray.length + " elements) = " + Arrays.toString(this.getFieldNameArray()) + ",\ncolList (" + colList.size() + " elements) = " + colList.toString());
        }
        try {
            this.detailLog.debug("===============");
            this.detailLog.debug("Setting values from excel file to bean started.");
            this.detailLog.debug("class name: " + this.getClass().getSimpleName());
            for (int i = 0; i < fieldNameArray.length; ++i) {
                String fieldName = fieldNameArray[i];
                if (fieldName == null) continue;
                Field field = null;
                Class<?> clazz = this.getClass();
                while (clazz != null) {
                    try {
                        field = clazz.getDeclaredField(fieldName);
                        break;
                    }
                    catch (NoSuchFieldException e) {
                        if ((clazz = clazz.getSuperclass()) != null) continue;
                        throw new RuntimeException("Trying to set a string value to the field in the bean, but the fieldName not found in the bean. \nbeanName: " + this.getClass().getSimpleName() + ", fieldName: " + fieldName);
                    }
                }
                Objects.requireNonNull(field);
                field.setAccessible(true);
                field.set(this, colList.get(i));
            }
            this.detailLog.debug("Setting values from excel file to bean finished successfully.");
            this.detailLog.debug("===============");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Nonnull
    protected String nullToEmpty(@Nullable String value) {
        return value == null ? "" : value;
    }

    @Nullable
    protected String emptyToNull(@Nullable String value) {
        return value == null || value.equals("") ? null : value;
    }

    @Nullable
    protected Integer toInteger(@Nullable String value) {
        return value == null || value.equals("") ? null : Integer.valueOf(value);
    }

    @Nullable
    protected Long toLong(@Nullable String value) {
        return value == null || value.equals("") ? null : Long.valueOf(value);
    }

    @Nullable
    protected Float toFloat(@Nullable String value) {
        return value == null || value.equals("") ? null : Float.valueOf(value);
    }

    @Nullable
    protected Double toDouble(@Nullable String value) {
        return value == null || value.equals("") ? null : Double.valueOf(value);
    }

    @Nullable
    protected BigInteger toBigInteger(@Nullable String value) {
        return value == null || value.equals("") ? null : new BigInteger(value);
    }

    @Nullable
    protected BigDecimal toBigDecimal(@Nullable String value) {
        return value == null || value.equals("") ? null : new BigDecimal(value);
    }
}

