/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.util.poi.excel.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.text.Format;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.util.poi.excel.enums.NoDataString;
import jp.ecuacion.util.poi.excel.exception.LoopBreakException;
import jp.ecuacion.util.poi.excel.table.ExcelTable;
import jp.ecuacion.util.poi.excel.table.reader.ExcelTableReader;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.ExcelStyleDateFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelReadUtil {
    private DetailLogger detailLog = new DetailLogger((Object)this);
    private static final String EMPTY_STRING = "";
    private String noDataString;
    private String defaultDateTimeFormat = "yyyy-MM-dd";

    public ExcelReadUtil() {
        this.noDataString = null;
    }

    public ExcelReadUtil(@Nonnull NoDataString noDataString) {
        ObjectsUtil.paramRequireNonNull((Object)((Object)noDataString));
        this.noDataString = noDataString == NoDataString.EMPTY_STRING ? EMPTY_STRING : null;
    }

    public void setDefaultDateTimeFormat(String dateTimeFormat) {
        this.defaultDateTimeFormat = dateTimeFormat;
    }

    @Nullable
    public String getNoDataStringIfNoData(@Nullable String value) {
        if (value == null || value.equals(EMPTY_STRING)) {
            return this.noDataString;
        }
        return value;
    }

    @Nullable
    public String getStringFromCell(@Nullable Cell cell) {
        return this.getStringFromCell(cell, this.defaultDateTimeFormat);
    }

    @Nullable
    public String getStringFromCell(@Nullable Cell cell, String dateTimeFormat) {
        if (dateTimeFormat == null) {
            dateTimeFormat = this.defaultDateTimeFormat;
        }
        String cellTypeString = null;
        cellTypeString = cell == null ? "(cell is null)" : cell.getCellType().toString();
        this.detailLog.debug("-----");
        this.detailLog.debug("cellType: " + cellTypeString);
        String value = this.internalGetStringFromCell(cell, dateTimeFormat);
        this.detailLog.debug("value: " + (value == null ? "(null)" : value));
        return value;
    }

    @Nullable
    private String internalGetStringFromCell(@Nullable Cell cell, String dateTimeFormat) {
        if (cell == null) {
            return this.noDataString;
        }
        CellType cellType = cell.getCellType();
        if (cellType == CellType.FORMULA) {
            return this.internalGetStringFromCellOtherThanFormulaCellType(cell, cell.getCachedFormulaResultType(), dateTimeFormat);
        }
        return this.internalGetStringFromCellOtherThanFormulaCellType(cell, cell.getCellType(), dateTimeFormat);
    }

    @Nullable
    private String internalGetStringFromCellOtherThanFormulaCellType(@Nonnull Cell cell, @Nullable CellType cellType, String dateTimeFormat) {
        if (cellType == CellType.BLANK) {
            return this.noDataString;
        }
        if (cellType == CellType.STRING) {
            return this.getNoDataStringIfNoData(cell.getStringCellValue());
        }
        if (cellType == CellType.NUMERIC) {
            DataFormatter fmter = new DataFormatter();
            Format fmt = fmter.createFormat(cell);
            this.detailLog.debug("Format: " + fmt.getClass().getSimpleName());
            if (fmt instanceof ExcelStyleDateFormatter) {
                return cell.getLocalDateTimeCellValue().format(DateTimeFormatter.ofPattern(dateTimeFormat));
            }
            String fmtVal = fmt.format(cell.getNumericCellValue());
            String toStrVal = Double.valueOf(cell.getNumericCellValue()).toString();
            boolean warning = false;
            if (!(fmtVal.equals(toStrVal) || fmtVal.contains(".") || toStrVal.endsWith(".0") && fmtVal.equals(toStrVal.substring(0, toStrVal.indexOf("."))))) {
                warning = true;
            }
            if (warning) {
                this.detailLog.warn("The number actual and displayed in excel differs. actual: " + toStrVal + "\u3001displayed: " + fmtVal);
            }
            return fmtVal;
        }
        throw new RuntimeException("cell type not found. cellType: " + cellType.toString());
    }

    public Workbook openForRead(String filePath) throws EncryptedDocumentException, IOException {
        return WorkbookFactory.create((File)new File(filePath), null, (boolean)true);
    }

    public <T> ExcelTable.ContextContainer getReadyToReadTableData(ExcelTableReader<T> reader, Workbook workbook, String sheetName, Integer numberOfHeaderLinesIfReadsHeaderOnlyOrNull) throws BizLogicAppException {
        this.detailLog.debug("===============");
        this.detailLog.debug("starting to read excel file.");
        this.detailLog.debug("sheet name :" + sheetName);
        Sheet sheet = workbook.getSheet(sheetName);
        if (sheet == null) {
            throw new BizLogicAppException("MSG_ERR_SHEET_NOT_EXIST", new String[]{sheetName});
        }
        Integer tableRowSize = numberOfHeaderLinesIfReadsHeaderOnlyOrNull == null ? reader.getTableRowSize() : numberOfHeaderLinesIfReadsHeaderOnlyOrNull;
        int poiBasisTableStartRowNumber = reader.getPoiBasisDeterminedTableStartRowNumber(sheet);
        int poiBasisTableStartColumnNumber = reader.getPoiBasisDeterminedTableStartColumnNumber();
        ExcelTable.ContextContainer context = new ExcelTable.ContextContainer(sheet, poiBasisTableStartRowNumber, poiBasisTableStartColumnNumber, tableRowSize, reader.getTableColumnSize(sheet, poiBasisTableStartRowNumber, poiBasisTableStartColumnNumber));
        return context;
    }

    public <T> List<T> readTableLine(ExcelTableReader<T> reader, ExcelTable.ContextContainer context, int rowNumber) {
        this.detailLog.debug("----------");
        this.detailLog.debug("row number\uff1a" + rowNumber);
        if (rowNumber == 10000) {
            throw new RuntimeException("'max':10000 exceeded.");
        }
        if (context.tableRowSize != null && rowNumber >= context.poiBasisTableStartRowNumber + context.tableRowSize) {
            throw new LoopBreakException();
        }
        Row row = context.sheet.getRow(rowNumber);
        ArrayList colList = new ArrayList();
        boolean isEmptyRow = true;
        if (row != null) {
            for (int j = context.poiBasisTableStartColumnNumber; j < context.poiBasisTableStartColumnNumber + context.tableColumnSize; ++j) {
                Cell cell = row.getCell(j);
                Object cellData = reader.getCellData(cell, j + 1);
                colList.add(cellData);
            }
            for (Object colData : colList) {
                if (reader.isCellDataEmpty(colData)) continue;
                isEmptyRow = false;
            }
        }
        if (isEmptyRow) {
            this.detailLog.debug("(no data in the line)");
            this.detailLog.debug("----------");
            if (context.tableRowSize == null) {
                throw new LoopBreakException();
            }
            return new ArrayList();
        }
        return colList;
    }
}

