/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.util.poi.excel.util;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Locale;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.util.poi.excel.enums.NoDataString;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.ExcelStyleDateFormatter;

public class ExcelReadUtil {
    private DetailLogger detailLog = new DetailLogger((Object)this);
    private static final String EMPTY_STRING = "";
    private String noDataString;

    public ExcelReadUtil() {
        this.noDataString = null;
    }

    public ExcelReadUtil(@Nonnull NoDataString noDataString) {
        ObjectsUtil.paramRequireNonNull((Object)((Object)noDataString));
        this.noDataString = noDataString == NoDataString.EMPTY_STRING ? EMPTY_STRING : null;
    }

    @Nullable
    public String getNoDataStringIfNoData(@Nullable String value) {
        if (value == null || value.equals(EMPTY_STRING)) {
            return this.noDataString;
        }
        return value;
    }

    @Nullable
    public String getStringFromCell(@Nullable Cell cell) {
        String cellTypeString = null;
        cellTypeString = cell == null ? "(cell is null)" : cell.getCellType().toString();
        this.detailLog.debug("-----");
        this.detailLog.debug("cellType: " + cellTypeString);
        String value = this.internalGetStringFromCell(cell);
        this.detailLog.debug("value: " + (value == null ? "(null)" : value));
        return value;
    }

    @Nullable
    private String internalGetStringFromCell(@Nullable Cell cell) {
        if (cell == null) {
            return this.noDataString;
        }
        CellType cellType = cell.getCellType();
        if (cellType == CellType.FORMULA) {
            return this.internalGetStringFromCellOtherThanFormulaCellType(cell, cell.getCachedFormulaResultType());
        }
        return this.internalGetStringFromCellOtherThanFormulaCellType(cell, cell.getCellType());
    }

    @Nullable
    private String internalGetStringFromCellOtherThanFormulaCellType(@Nonnull Cell cell, @Nullable CellType cellType) {
        if (cellType == CellType.BLANK) {
            return this.noDataString;
        }
        if (cellType == CellType.STRING) {
            return this.getNoDataStringIfNoData(cell.getStringCellValue());
        }
        if (cellType == CellType.NUMERIC) {
            DataFormatter fmter = new DataFormatter();
            Format fmt = fmter.createFormat(cell);
            this.detailLog.debug("Format: " + fmt.getClass().getSimpleName());
            if (fmt instanceof ExcelStyleDateFormatter) {
                CellStyle style = cell.getCellStyle();
                String dateFormatString = null;
                this.detailLog.debug("dataFormat (index) : " + style.getDataFormat());
                if (style.getDataFormat() == 14) {
                    Locale locale = Locale.getDefault();
                    dateFormatString = locale.getLanguage().equals("ja") ? "yyyy/M/d" : style.getDataFormatString();
                } else {
                    this.detailLog.debug("The dataFormat other than 14 is not recommended. It may not be correct.");
                    dateFormatString = style.getDataFormatString();
                }
                this.detailLog.debug("dataFormatString(poi original) : " + style.getDataFormatString());
                this.detailLog.debug("dataFormatString(corrected) : " + dateFormatString);
                SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatString);
                return dateFormat.format(cell.getDateCellValue());
            }
            String fmtVal = fmt.format(cell.getNumericCellValue());
            String toStrVal = Double.valueOf(cell.getNumericCellValue()).toString();
            boolean warning = false;
            if (!(fmtVal.equals(toStrVal) || fmtVal.contains(".") || toStrVal.endsWith(".0") && fmtVal.equals(toStrVal.substring(0, toStrVal.indexOf("."))))) {
                warning = true;
            }
            if (warning) {
                this.detailLog.warn("\u30a8\u30af\u30bb\u30eb\u8868\u793a\u4e0a\u306e\u6570\u5024\u3068\u5b9f\u969b\u306e\u30bb\u30eb\u306e\u5024\u304c\u7570\u306a\u3063\u3066\u3044\u307e\u3059\u3002\u8868\u793a\u4e0a\uff1a" + fmtVal + "\u3001\u30bb\u30eb\u306e\u5024\uff1a" + toStrVal);
            }
            return fmtVal;
        }
        throw new RuntimeException("cell\u306e\u578b\u304c\u5f53\u3066\u306f\u307e\u308a\u307e\u305b\u3093\u3002");
    }
}

