/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.util.poi.excel.table.writer.concrete;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.List;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.util.poi.excel.table.IfFormatOneLineHeaderExcelTable;
import jp.ecuacion.util.poi.excel.table.reader.concrete.StringFreeExcelTableReader;
import jp.ecuacion.util.poi.excel.table.writer.ExcelTableWriter;
import jp.ecuacion.util.poi.excel.table.writer.IfDataTypeCellExcelTableWriter;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ss.usermodel.Cell;

public class CellOneLineHeaderExcelTableWriter
extends ExcelTableWriter<Cell>
implements IfDataTypeCellExcelTableWriter,
IfFormatOneLineHeaderExcelTable<Cell> {
    @Nonnull
    private String[] headerLabels;

    public CellOneLineHeaderExcelTableWriter(@RequireNonnull String sheetName, @RequireNonnull String[] headerLabels, @Nullable Integer tableStartRowNumber, int tableStartColumnNumber) {
        super(sheetName, tableStartRowNumber, tableStartColumnNumber);
        this.headerLabels = (String[])ObjectsUtil.paramRequireNonNull((Object)headerLabels);
    }

    @Override
    @Nonnull
    public String[] getHeaderLabels() {
        return this.headerLabels;
    }

    @Override
    protected List<List<String>> getHeaderList(String templateFilePath, int tableColumnSize) throws EncryptedDocumentException, AppException, IOException {
        return new StringFreeExcelTableReader(this.getSheetName(), this.tableStartRowNumber, this.tableStartColumnNumber, 1, tableColumnSize).read(templateFilePath.toString());
    }
}

