/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.util.poi.excel.table.writer;

import jakarta.annotation.Nullable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.util.poi.excel.table.ExcelTable;
import jp.ecuacion.util.poi.excel.table.IfFormatOneLineHeaderExcelTable;
import jp.ecuacion.util.poi.excel.table.writer.IfExcelTableWriter;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public abstract class ExcelTableWriter<T>
extends ExcelTable<T>
implements IfExcelTableWriter<T> {
    private DetailLogger detailLog = new DetailLogger((Object)this);

    public ExcelTableWriter(@RequireNonnull String sheetName, @Nullable Integer tableStartRowNumber, int tableStartColumnNumber) {
        super(sheetName, tableStartRowNumber, tableStartColumnNumber);
    }

    public void write(String templateFilePath, String destFilePath, List<List<T>> dataList) throws Exception {
        List<List<String>> headerList = this.getHeaderList(templateFilePath, dataList.get(0).size());
        this.validateHeader(headerList);
        this.writeTableValues(templateFilePath, destFilePath, dataList);
    }

    protected abstract List<List<String>> getHeaderList(@RequireNonnull String var1, int var2) throws EncryptedDocumentException, AppException, IOException;

    private void writeTableValues(@RequireNonnull String templateFilePath, @RequireNonnull String destFilePath, @RequireNonnull List<List<T>> dataList) throws FileNotFoundException, IOException, BizLogicAppException {
        Sheet sheet;
        XSSFWorkbook excel;
        this.detailLog.debug("===============");
        this.detailLog.debug("starting to write excel file.");
        this.detailLog.debug("template file name  :" + (templateFilePath == null ? "(none)" : templateFilePath));
        this.detailLog.debug("sheet name :" + this.getSheetName());
        Object object = excel = templateFilePath == null ? new XSSFWorkbook() : WorkbookFactory.create((File)new File(templateFilePath), null, (boolean)false);
        if (templateFilePath == null) {
            excel.createSheet(this.getSheetName());
        }
        if ((sheet = excel.getSheet(this.getSheetName())) == null) {
            throw new BizLogicAppException("MSG_ERR_SHEET_NOT_EXIST", new String[]{templateFilePath, this.getSheetName()});
        }
        int poiBasisTableStartColumnNumber = this.getPoiBasisDeterminedTableStartColumnNumber();
        int poiBasisTableStartRowNumber = this.getPoiBasisDeterminedTableStartRowNumber(sheet);
        if (this instanceof IfFormatOneLineHeaderExcelTable) {
            ++poiBasisTableStartRowNumber;
        }
        for (int rowNum = poiBasisTableStartRowNumber; rowNum < poiBasisTableStartRowNumber + dataList.size(); ++rowNum) {
            List<T> list = dataList.get(rowNum - poiBasisTableStartRowNumber);
            if (sheet.getRow(rowNum) == null) {
                sheet.createRow(rowNum);
            }
            Row row = sheet.getRow(rowNum);
            for (int colNum = poiBasisTableStartColumnNumber; colNum < poiBasisTableStartColumnNumber + dataList.get(0).size(); ++colNum) {
                T sourceCellData = list.get(colNum - poiBasisTableStartColumnNumber);
                if (row.getCell(colNum) == null) {
                    row.createCell(colNum);
                }
                Cell destCell = row.getCell(colNum);
                this.writeToCell(sourceCellData, destCell);
            }
        }
        try (FileOutputStream out = new FileOutputStream(destFilePath);){
            excel.write((OutputStream)out);
        }
    }
}

