/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.util.poi.excel.table.reader;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Min;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.lib.core.util.BeanValidationUtil;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.util.poi.excel.table.ExcelTable;
import jp.ecuacion.util.poi.excel.table.reader.IfExcelTableReader;
import jp.ecuacion.util.poi.excel.util.ExcelReadUtil;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public abstract class ExcelTableReader<T>
extends ExcelTable<T>
implements IfExcelTableReader<T> {
    private DetailLogger detailLog = new DetailLogger((Object)this);
    private ExcelReadUtil readUtil = new ExcelReadUtil();
    @Min(value=1L)
    protected @Min(value=1L) Integer tableRowSize;
    @Min(value=1L)
    protected @Min(value=1L) Integer tableColumnSize;

    public ExcelTableReader(@RequireNonnull String sheetName, @Nullable Integer tableStartRowNumber, int tableStartColumnNumber, @Nullable Integer tableRowSize, @Nullable Integer tableColumnSize) {
        super(sheetName, tableStartRowNumber, tableStartColumnNumber);
        this.tableRowSize = tableRowSize;
        this.tableColumnSize = tableColumnSize;
        Set violationSet = new BeanValidationUtil().validate((Object)this, Locale.getDefault());
        if (violationSet != null && violationSet.size() > 0) {
            throw new RuntimeException("Validation failed at TableReader constructor.");
        }
    }

    @Nonnull
    public List<List<T>> read(@RequireNonnull String excelPath) throws EncryptedDocumentException, AppException, IOException {
        List<List<T>> rtnList = this.readTableValues(excelPath);
        List<List<String>> headerList = this.updateAndGetHeaderList(rtnList);
        this.validateHeader(headerList);
        return rtnList;
    }

    @Nonnull
    private List<List<T>> readTableValues(@RequireNonnull String excelPath) throws AppException, EncryptedDocumentException, IOException {
        this.detailLog.debug("===============");
        this.detailLog.debug("starting to read excel file.");
        this.detailLog.debug("file name  :" + excelPath);
        this.detailLog.debug("sheet name :" + this.getSheetName());
        Workbook excel = WorkbookFactory.create((File)new File(excelPath), null, (boolean)true);
        Sheet sheet = excel.getSheet(this.getSheetName());
        if (sheet == null) {
            throw new BizLogicAppException("MSG_ERR_SHEET_NOT_EXIST", new String[]{excelPath, this.getSheetName()});
        }
        int poiBasisTableStartColumnNumber = this.getPoiBasisDeterminedTableStartColumnNumber();
        int poiBasisTableStartRowNumber = this.getPoiBasisDeterminedTableStartRowNumber(sheet);
        int tableColumnSize = this.getTableColumnSize(sheet, poiBasisTableStartRowNumber, poiBasisTableStartColumnNumber);
        Integer tableRowSize = this.getTableRowSize();
        ArrayList<List<T>> rowList = new ArrayList<List<T>>();
        int max = 10000;
        for (int rowNumber = poiBasisTableStartRowNumber; rowNumber <= max; ++rowNumber) {
            this.detailLog.debug("----------");
            this.detailLog.debug("row number\uff1a" + rowNumber);
            if (rowNumber == max) {
                throw new RuntimeException("'max':" + max + " exceeded.");
            }
            if (tableRowSize != null && rowNumber >= poiBasisTableStartRowNumber + tableRowSize) break;
            Row row = sheet.getRow(rowNumber);
            ArrayList colList = new ArrayList();
            boolean isEmptyRow = true;
            if (row != null) {
                for (int j = poiBasisTableStartColumnNumber; j < poiBasisTableStartColumnNumber + tableColumnSize; ++j) {
                    Cell cell = row.getCell(j);
                    Object cellData = this.getCellData(cell);
                    colList.add(cellData);
                }
                for (Object colData : colList) {
                    if (this.isCellDataEmpty(colData)) continue;
                    isEmptyRow = false;
                    break;
                }
            }
            if (isEmptyRow) {
                this.logNoMoreLines();
                if (tableRowSize == null) break;
                rowList.add(new ArrayList());
                continue;
            }
            rowList.add(colList);
        }
        excel.close();
        this.detailLog.debug("finishing to read excel file. sheet name :" + this.getSheetName());
        this.detailLog.debug("===============");
        return rowList;
    }

    @Nullable
    protected Integer getTableRowSize() {
        return this.tableRowSize;
    }

    @Nonnull
    protected Integer getTableColumnSize(@RequireNonnull Sheet sheet, int poiBasisDeterminedTableStartRowNumber, int poiBasisDeterminedTableStartColumnNumber) throws BizLogicAppException {
        Cell cell;
        ObjectsUtil.paramRequireNonNull((Object)sheet);
        if (this.tableColumnSize != null) {
            return Objects.requireNonNull(this.tableColumnSize);
        }
        Row row = sheet.getRow(poiBasisDeterminedTableStartRowNumber);
        ObjectsUtil.requireNonNull((Object)row);
        int columnNumber = poiBasisDeterminedTableStartColumnNumber;
        while ((cell = row.getCell(columnNumber)) != null && !this.isCellDataEmpty(this.getCellData(cell))) {
            ++columnNumber;
        }
        int size = columnNumber - poiBasisDeterminedTableStartColumnNumber;
        if (size == 0) {
            throw new BizLogicAppException("", new String[0]);
        }
        return size;
    }

    private void logNoMoreLines() {
        this.detailLog.debug("(no data in the line)");
        this.detailLog.debug("----------");
    }

    public void setTableColumnSize(int tableColumnSize) {
        this.tableColumnSize = tableColumnSize;
    }

    @Override
    public ExcelReadUtil getExcelReadUtil() {
        return this.readUtil;
    }
}

