/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.util.poi.excel.table;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import jp.ecuacion.lib.core.annotation.RequireNonnull;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.util.poi.excel.table.IfExcelTable;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public abstract class ExcelTable<T>
implements IfExcelTable<T> {
    @NotNull
    @Nonnull
    protected String sheetName;
    @Nullable
    @Min(value=1L)
    protected @Min(value=1L) Integer tableStartRowNumber;
    @Min(value=1L)
    protected @Min(value=1L) int tableStartColumnNumber;

    public ExcelTable(@RequireNonnull String sheetName, @Nullable Integer tableStartRowNumber, int tableStartColumnNumber) {
        this.sheetName = (String)ObjectsUtil.paramRequireNonNull((Object)sheetName);
        this.tableStartRowNumber = tableStartRowNumber;
        this.tableStartColumnNumber = tableStartColumnNumber;
    }

    @Override
    @Nonnull
    public String getSheetName() {
        return (String)ObjectsUtil.returnRequireNonNull((Object)this.sheetName);
    }

    protected int getPoiBasisDeterminedTableStartRowNumber(@RequireNonnull Sheet sheet) {
        ObjectsUtil.paramRequireNonNull((Object)sheet);
        if (this.tableStartRowNumber != null) {
            return Objects.requireNonNull(this.tableStartRowNumber) - 1;
        }
        for (int i = 0; i < 100; ++i) {
            String value;
            Cell cell;
            Row row = sheet.getRow(i);
            if (row == null || (cell = row.getCell(0)) == null || !(value = cell.getStringCellValue()).equals(this.getFarLeftHeaderLabel())) continue;
            return i;
        }
        throw new RuntimeException("\u30b7\u30fc\u30c8\u300c" + sheet.getSheetName() + "\u300d\u306b\u6587\u5b57\u5217\u300c" + this.getFarLeftHeaderLabel() + "\u300d\u304c" + this.tableStartColumnNumber + "\u756a\u76ee\u306e\u5217\u306b\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u7d42\u4e86\u3057\u307e\u3059\u3002");
    }

    protected int getPoiBasisDeterminedTableStartColumnNumber() {
        return this.tableStartColumnNumber - 1;
    }
}

