/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.tool.housekeepfiles.tasklet;

import java.util.Map;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.tool.housekeepfiles.blf.HousekeepFilesBlf;
import jp.ecuacion.tool.housekeepfiles.dto.form.HousekeepFilesForm;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.stereotype.Component;

@Component
public class HousekeepFilesTasklet
implements Tasklet {
    HousekeepFilesBlf blf = new HousekeepFilesBlf();
    HousekeepFilesForm form = null;

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        Map paramMap = chunkContext.getStepContext().getJobParameters();
        String excelPath = (String)paramMap.get("excelPath");
        this.execute(excelPath);
        return RepeatStatus.FINISHED;
    }

    public void execute(String excelFilePath) throws AppException, Exception {
        if (excelFilePath == null || excelFilePath.equals("")) {
            throw new BizLogicAppException("MSG_ERR_PARAM_NULL_OR_EMPTY", new String[]{"1st argument(excelFilePath)"});
        }
        if (!excelFilePath.contains(".")) {
            throw new BizLogicAppException("MSG_ERR_1ST_ARG_HAS_NO_EXTENSION", new String[]{excelFilePath});
        }
        String extension = excelFilePath.substring(excelFilePath.lastIndexOf("."));
        if (!extension.equals(".xlsx")) {
            throw new BizLogicAppException("MSG_ERR_EXTENSION_NOT_EXPECTED", new String[]{extension});
        }
        this.form = this.getFormFromExcel(excelFilePath);
        this.blf.execute(this.form);
    }

    HousekeepFilesForm getFormFromExcel(String excelPath) throws AppException {
        return new HousekeepFilesForm(excelPath);
    }
}

