/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.tool.housekeepfiles.blf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.tool.housekeepfiles.bean.ConnectionToRemoteServer;
import jp.ecuacion.tool.housekeepfiles.bl.HousekeepFilesBl;
import jp.ecuacion.tool.housekeepfiles.bl.task.AbstractTask;
import jp.ecuacion.tool.housekeepfiles.bl.task.AbstractTaskLocal;
import jp.ecuacion.tool.housekeepfiles.dto.form.HousekeepFilesForm;
import jp.ecuacion.tool.housekeepfiles.dto.other.HousekeepFilesExpandedPathsInfo;
import jp.ecuacion.tool.housekeepfiles.dto.record.HousekeepFilesAuthRecord;
import jp.ecuacion.tool.housekeepfiles.dto.record.HousekeepFilesTaskRecord;

public class HousekeepFilesBlf {
    DetailLogger dlog = new DetailLogger((Object)this);
    HousekeepFilesBl bl = new HousekeepFilesBl();

    public HousekeepFilesBlf() {
    }

    public HousekeepFilesBlf(HousekeepFilesBl bl) {
        this.bl = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(HousekeepFilesForm form) throws Exception {
        this.logJobStartMsg(form);
        ArrayList warnList = new ArrayList();
        this.bl.consistencyCheckBetweenMultipleData(form);
        HashMap envVarInfoMap = this.bl.createPathInfoMap(form);
        Map<String, HousekeepFilesAuthRecord> authMap = form.getAuthInfoRecList().stream().collect(Collectors.toMap(rec -> rec.getRemoteServer() + "-" + rec.getProtocol(), rec -> rec));
        this.bl.envVarExistenceCheckAndSetEnvBarExpandedPaths(form.getTaskInfoHdRec().recList, (Map)envVarInfoMap);
        ArrayList exList = new ArrayList();
        this.bl.createTaskAndTaskDependentCheck(form, exList);
        if (exList.size() > 0) {
            throw new MultipleAppException(exList);
        }
        HashMap connectionMap = new HashMap();
        try {
            for (HousekeepFilesTaskRecord housekeepFilesTaskRecord : form.getTaskInfoHdRec().recList) {
                this.execEachTask(housekeepFilesTaskRecord.task, connectionMap, housekeepFilesTaskRecord, (Map)envVarInfoMap, authMap, warnList);
            }
        }
        catch (Throwable throwable) {
            for (Map.Entry entry : connectionMap.entrySet()) {
                ((ConnectionToRemoteServer)entry.getValue()).closeConnection();
            }
            throw throwable;
        }
        for (Map.Entry entry : connectionMap.entrySet()) {
            ((ConnectionToRemoteServer)entry.getValue()).closeConnection();
        }
        if (!warnList.isEmpty()) {
            this.bl.sendWarnMail(warnList, form.getTaskInfoHdRec());
        }
        this.logJobFinishMsg(form);
    }

    private void logJobStartMsg(HousekeepFilesForm form) {
        this.dlog.debug("####################");
        this.dlog.debug("##### startJob :" + form.getTaskInfoHdRec().getSysName());
    }

    private void logJobFinishMsg(HousekeepFilesForm form) {
        this.dlog.debug("##### finishJob:" + form.getTaskInfoHdRec().getSysName());
    }

    protected void execEachTask(AbstractTask task, Map<String, ConnectionToRemoteServer> connectionMap, HousekeepFilesTaskRecord taskInfo, Map<String, String> envVarInfoMap, Map<String, HousekeepFilesAuthRecord> authMap, List<AppException> warnList) throws Exception {
        String connectionKey = taskInfo.getRemoteServer() + "." + task.getConnectionProtocol();
        if (!(task instanceof AbstractTaskLocal) && !connectionMap.containsKey(connectionKey)) {
            connectionMap.put(connectionKey, task.getConnection(taskInfo.getRemoteServer(), authMap));
        }
        ConnectionToRemoteServer conn = connectionMap.get(connectionKey);
        HousekeepFilesExpandedPathsInfo pathInfo = this.bl.expandAllPath(task, taskInfo, envVarInfoMap, conn);
        if (pathInfo.tmpToFileList.size() > 0) {
            pathInfo.toPath = (String)pathInfo.tmpToFileList.get(0);
        }
        warnList.addAll(this.bl.logicalCheckTaskListAfterEnvVarExpansion(task, taskInfo, pathInfo));
        this.bl.doTaskForMultipleFiles(taskInfo, pathInfo, conn, warnList);
    }
}

