/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.tool.housekeepfiles.bl.task;

import java.io.File;
import java.util.List;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.exception.checked.SingleAppException;
import jp.ecuacion.tool.housekeepfiles.bean.ConnectionToRemoteServer;
import jp.ecuacion.tool.housekeepfiles.bl.task.AbstractTaskLocal;
import jp.ecuacion.tool.housekeepfiles.dto.record.HousekeepFilesTaskRecord;
import jp.ecuacion.tool.housekeepfiles.enums.TaskActionKindEnum;
import jp.ecuacion.tool.housekeepfiles.enums.TaskPtnEnum;

public class CreateFile
extends AbstractTaskLocal {
    public CreateFile() {
        this.taskPtn = TaskPtnEnum.CREATE_FILE;
    }

    public TaskActionKindEnum getTaskActionKind() {
        return TaskActionKindEnum.create;
    }

    public void taskDependentCheck(HousekeepFilesTaskRecord taskRec, List<SingleAppException> exList) {
        if (taskRec.getIsDestPathDir().booleanValue()) {
            exList.add((SingleAppException)new BizLogicAppException("MSG_ERR_TASK_CANNOT_SET_IS_DEST_PATH_DIR_TO_VALUE", new String[]{taskRec.getTaskId(), taskRec.taskPtnEnumName, "TRUE"}));
        }
        if (taskRec.getDoesOverwriteDestPath().booleanValue()) {
            exList.add((SingleAppException)new BizLogicAppException("MSG_ERR_TASK_CANNOT_SET_OVERWRITE_TO_VALUE", new String[]{taskRec.getTaskId(), taskRec.taskPtnEnumName, "TRUE"}));
        }
    }

    protected void doTaskInternal(ConnectionToRemoteServer conn, HousekeepFilesTaskRecord taskRec, String fromPath, String destPath, List<AppException> warnList) throws Exception {
        File dest = new File(destPath);
        if (dest.exists() && !dest.isDirectory()) {
            this.treatDestPathExists(taskRec, destPath, warnList);
        }
        if (dest.exists() && dest.isDirectory()) {
            throw new BizLogicAppException("MSG_ERR_DEST_PATH_IS_DIR", new String[]{taskRec.getTaskId(), taskRec.getTaskName(), destPath});
        }
        File parent = new File(dest.getParent());
        if (!parent.exists() || !parent.isDirectory()) {
            throw new BizLogicAppException("MSG_ERR_PARENT_DIR_NOT_EXIST", new String[]{taskRec.getTaskId(), taskRec.getTaskName(), parent.getAbsolutePath()});
        }
        dest.createNewFile();
    }
}

