/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.tool.housekeepfiles.util;

import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class DateTimeUtil {
    public String getYear(String date) {
        return date.substring(0, 4);
    }

    public String getMonth(String date) {
        return date.substring(4, 6);
    }

    public String getDay(String date) {
        return date.substring(6, 8);
    }

    private String lpadZero(int number, int size) {
        return StringUtils.leftPad((String)Integer.toString(number), (int)size, (String)"0");
    }

    public String getTimestampNumString() {
        Calendar cal = Calendar.getInstance();
        return String.valueOf(cal.get(1)) + this.lpadZero(cal.get(2) + 1, 2) + this.lpadZero(cal.get(5), 2) + "-" + this.lpadZero(cal.get(11), 2) + this.lpadZero(cal.get(12), 2) + this.lpadZero(cal.get(13), 2) + "." + StringUtils.rightPad((String)String.valueOf(cal.get(14)), (int)3, (String)"0");
    }

    public String getDateStr8() {
        Calendar cal = Calendar.getInstance();
        return Integer.toString(cal.get(1)) + this.lpadZero(cal.get(2) + 1, 2) + this.lpadZero(cal.get(5), 2);
    }

    public boolean hasDesignatedTermPassed(long lastModified, int unit, int value) {
        Calendar calFileLastModified = Calendar.getInstance();
        calFileLastModified.setTimeInMillis(lastModified);
        Calendar calDesignatedTime = this.getCurrentCal();
        if (value == 0) {
            return true;
        }
        if (unit == 13) {
            calDesignatedTime.add(13, -1 * value);
        } else if (unit == 12) {
            calDesignatedTime.add(12, -1 * value);
        } else if (unit == 10) {
            calDesignatedTime.add(10, -1 * value);
        } else if (unit == 5) {
            calDesignatedTime.add(5, -1 * value);
        } else if (unit == 2) {
            calDesignatedTime.add(2, -1 * value);
        } else if (unit == 1) {
            calDesignatedTime.add(1, -1 * value);
        }
        Date dateFileLastModified = this.makeUnusedCalendarUnitValToFixedVal(calFileLastModified, unit);
        Date dateDesignatedTime = this.makeUnusedCalendarUnitValToFixedVal(calDesignatedTime, unit);
        return dateFileLastModified.getTime() <= dateDesignatedTime.getTime();
    }

    protected Calendar getCurrentCal() {
        return Calendar.getInstance();
    }

    private Date makeUnusedCalendarUnitValToFixedVal(Calendar cal, int timeUnit) {
        int year = cal.get(1);
        int month = timeUnit == 1 ? 0 : cal.get(2);
        int day = timeUnit == 1 || timeUnit == 2 ? 0 : cal.get(5);
        int hour = timeUnit == 1 || timeUnit == 2 || timeUnit == 5 ? 0 : cal.get(11);
        int minute = timeUnit == 1 || timeUnit == 2 || timeUnit == 5 || timeUnit == 10 ? 0 : cal.get(12);
        int second = timeUnit == 1 || timeUnit == 2 || timeUnit == 5 || timeUnit == 10 || timeUnit == 12 ? 0 : cal.get(13);
        Calendar rtnCal = Calendar.getInstance();
        rtnCal.clear();
        rtnCal.set(year, month, day, hour, minute, second);
        return rtnCal.getTime();
    }
}

