/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.tool.housekeepfiles.bl.task;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.util.List;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.exception.checked.SingleAppException;
import jp.ecuacion.tool.housekeepfiles.bean.ConnectionToRemoteServer;
import jp.ecuacion.tool.housekeepfiles.bean.ConnectionToSftpServer;
import jp.ecuacion.tool.housekeepfiles.bl.task.AbstractTaskSftp;
import jp.ecuacion.tool.housekeepfiles.bl.task.internal.CreateDirInterface;
import jp.ecuacion.tool.housekeepfiles.dto.record.HousekeepFilesTaskRecord;
import jp.ecuacion.tool.housekeepfiles.enums.TaskActionKindEnum;
import jp.ecuacion.tool.housekeepfiles.enums.TaskPtnEnum;

public class SftpCreateDir
extends AbstractTaskSftp
implements CreateDirInterface {
    public SftpCreateDir() {
        this.taskPtn = TaskPtnEnum.SFTP_CREATE_DIR;
    }

    public TaskActionKindEnum getTaskActionKind() {
        return TaskActionKindEnum.create;
    }

    public Boolean isSrcPathLocal() {
        return null;
    }

    public Boolean isDestPathLocal() {
        return false;
    }

    public void taskDependentCheck(HousekeepFilesTaskRecord taskRec, List<SingleAppException> exList) {
        this.taskDependentCheckCreateDir(exList, taskRec);
    }

    protected void doSpecificTask(ConnectionToRemoteServer connection, HousekeepFilesTaskRecord taskRec, String srcPath, String destPath, List<AppException> warnList) throws Exception {
        ChannelSftp channel = ((ConnectionToSftpServer)connection).getSftpChannel();
        if (this.remoteDirExists(channel, destPath)) {
            this.treatDestPathExists(taskRec, destPath, warnList);
            return;
        }
        if (this.remoteFileExists(channel, destPath)) {
            throw new BizLogicAppException("MSG_ERR_DEST_PATH_IS_FILE", new String[]{taskRec.getTaskId(), taskRec.getTaskName(), destPath});
        }
        this.createDirRecursively(channel, taskRec, destPath);
    }

    private void createDirRecursively(ChannelSftp channel, HousekeepFilesTaskRecord taskRec, String destPath) throws SftpException, BizLogicAppException {
        String parentPath = new File(destPath).getParent();
        if (!this.remoteExists(channel, parentPath)) {
            this.createDirRecursively(channel, taskRec, parentPath);
        }
        if (!this.remoteDirExists(channel, parentPath)) {
            throw new BizLogicAppException("MSG_ERR_DEST_PATH_IS_FILE", new String[]{taskRec.getTaskId(), taskRec.getTaskName(), destPath});
        }
        channel.mkdir(destPath);
    }
}

