/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.tool.housekeepfiles.bl;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.lib.core.exception.checked.SingleAppException;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.lib.core.util.EmbeddedParameterUtil;
import jp.ecuacion.lib.core.util.ExceptionUtil;
import jp.ecuacion.lib.core.util.FileUtil;
import jp.ecuacion.lib.core.util.MailUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import jp.ecuacion.lib.core.util.StringUtil;
import jp.ecuacion.lib.core.util.ValidationUtil;
import jp.ecuacion.tool.housekeepfiles.bean.ConnectionToRemoteServer;
import jp.ecuacion.tool.housekeepfiles.bl.task.AbstractTask;
import jp.ecuacion.tool.housekeepfiles.bl.task.TaskAttrCheckPtnEnum;
import jp.ecuacion.tool.housekeepfiles.dto.form.HousekeepFilesForm;
import jp.ecuacion.tool.housekeepfiles.dto.other.FileInfo;
import jp.ecuacion.tool.housekeepfiles.dto.other.HousekeepFilesExpandedPathsInfo;
import jp.ecuacion.tool.housekeepfiles.dto.record.HousekeepFilesHdRecord;
import jp.ecuacion.tool.housekeepfiles.dto.record.HousekeepFilesPathRecord;
import jp.ecuacion.tool.housekeepfiles.dto.record.HousekeepFilesTaskRecord;
import jp.ecuacion.tool.housekeepfiles.enums.IncidentTreatedAsEnum;
import jp.ecuacion.tool.housekeepfiles.enums.TaskActionKindEnum;
import jp.ecuacion.tool.housekeepfiles.enums.TaskPtnEnum;
import jp.ecuacion.tool.housekeepfiles.util.DateTimeUtil;
import jp.ecuacion.tool.housekeepfiles.util.HkFileManipulateUtil;

public class HousekeepFilesBl {
    public static final String EXTENSION_NONE_WITH_DOT = "";
    public static final String EXTENSION_ZIP_WITH_DOT = ".zip";
    private DetailLogger dlog = new DetailLogger((Object)this);
    private DateTimeUtil dateUtil = new DateTimeUtil();
    private HkFileManipulateUtil fmu = new HkFileManipulateUtil();

    public void consistencyCheckBetweenMultipleData(HousekeepFilesForm form) throws AppException {
        ValidationUtil.validateThenThrow((Object)form.getTaskInfoHdRec());
        if (form.getTaskInfoHdRec().recList == null || form.getTaskInfoHdRec().recList.size() == 0) {
            throw new BizLogicAppException("MSG_ERR_AT_LEAST_ONE_TASK_NEEDED", new String[0]);
        }
        HashSet<String> taskIdSet = new HashSet<String>();
        HashSet<String> taskNameSet = new HashSet<String>();
        for (HousekeepFilesTaskRecord rec : form.getTaskInfoHdRec().recList) {
            if (taskIdSet.contains(rec.getTaskId())) {
                throw new BizLogicAppException("MSG_ERR_TASK_ID_DUPLICATED", new String[]{rec.getTaskId()});
            }
            taskIdSet.add(rec.getTaskId());
            if (taskNameSet.contains(rec.getTaskName())) {
                throw new BizLogicAppException("MSG_ERR_TASK_NAME_DUPLICATED", new String[]{rec.getTaskName()});
            }
            taskNameSet.add(rec.getTaskName());
        }
    }

    public HashMap<String, String> createPathInfoMap(HousekeepFilesForm form) throws UnknownHostException {
        HashMap<String, String> pathInfoMap = new HashMap<String, String>();
        for (HousekeepFilesPathRecord pathInfo : form.getPathInfoRecList()) {
            pathInfoMap.put(pathInfo.getKey(), pathInfo.getValue());
        }
        pathInfoMap.put("SYS_NAME", form.getTaskInfoHdRec().getSysName());
        pathInfoMap.put("YYYYMMDD", this.dateUtil.getDateStr8());
        pathInfoMap.put("TIMESTAMP", this.dateUtil.getTimestampNumString());
        pathInfoMap.put("HOSTNAME", InetAddress.getLocalHost().getHostName());
        return pathInfoMap;
    }

    public void envVarExistenceCheckAndSetEnvBarExpandedPaths(List<HousekeepFilesTaskRecord> taskRecList, Map<String, String> envVarInfoMap) throws AppException {
        ArrayList exArr = new ArrayList();
        for (HousekeepFilesTaskRecord rec : taskRecList) {
            if (rec.getSrcPath() != null) {
                this.analyzePathVarAndCheckIfExistsInSet(rec, envVarInfoMap.keySet(), exArr, rec.getSrcPath());
            }
            if (rec.getDestPath() != null) {
                this.analyzePathVarAndCheckIfExistsInSet(rec, envVarInfoMap.keySet(), exArr, rec.getDestPath());
            }
            rec.setEnvVarInfoMap(envVarInfoMap);
        }
    }

    private void analyzePathVarAndCheckIfExistsInSet(HousekeepFilesTaskRecord taskRec, Set<String> pathKeySet, List<SingleAppException> exArr, String path) throws BizLogicAppException, MultipleAppException {
        HashSet<String> keySet = new HashSet<String>(pathKeySet);
        keySet.addAll(Arrays.asList("TASK_NAME", "YYYYMMDD", "TIMESTAMP", "HOSTNAME"));
        Map<String, String> paramMap = keySet.stream().collect(Collectors.toMap(s -> s, s -> s));
        EmbeddedParameterUtil.getParameterReplacedString((String)path, (String)"${", (String)"}", paramMap);
    }

    public void createTaskAndTaskDependentCheck(HousekeepFilesForm form, List<SingleAppException> exList) throws Exception {
        for (HousekeepFilesTaskRecord dtRec : form.getTaskInfoHdRec().recList) {
            this.createTaskInstance(exList, dtRec, dtRec.getTaskPtn());
            try {
                dtRec.task.check(dtRec);
            }
            catch (AppException ex) {
                if (ex instanceof MultipleAppException) {
                    exList.addAll(((MultipleAppException)ex).getList());
                    continue;
                }
                exList.add((SingleAppException)ex);
            }
        }
    }

    public void createTaskInstance(List<SingleAppException> exList, HousekeepFilesTaskRecord dtRec, TaskPtnEnum taskPtn) throws Exception {
        Class<?> cls = Class.forName("jp.ecuacion.tool.housekeepfiles.bl.task." + StringUtil.getUpperCamelFromSnake((String)taskPtn.toString()));
        dtRec.task = (AbstractTask)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public HousekeepFilesExpandedPathsInfo expandAllPath(AbstractTask task, HousekeepFilesTaskRecord taskRec, Map<String, String> envVarInfoMap, ConnectionToRemoteServer connection) throws Exception {
        ArrayList fromPathList = new ArrayList();
        ArrayList toPathList = new ArrayList();
        if (task.hasSrcPathInfo()) {
            this.expandFromPath(envVarInfoMap, connection, taskRec, task, fromPathList);
        }
        if (task.hasDestPathInfo()) {
            this.expandToPath(envVarInfoMap, connection, taskRec, task, toPathList);
        }
        return new HousekeepFilesExpandedPathsInfo(fromPathList, toPathList);
    }

    private void expandFromPath(Map<String, String> envVarInfoMap, ConnectionToRemoteServer connection, HousekeepFilesTaskRecord taskRec, AbstractTask task, List<String> fromPathList) throws AppException {
        List tmpFromFileAndDirMixedList = task.getFromDirFileInfoList(task, connection, taskRec.getIsSrcPathDir().booleanValue(), taskRec.getEnvVarExpandedSrcPath());
        for (FileInfo fi : tmpFromFileAndDirMixedList) {
            if (taskRec.getIsSrcPathDir() != true == fi.isDirectory() || !this.dateUtil.hasDesignatedTermPassed(fi.getLastUpdTimeInMillis(), taskRec.getUnit().intValue(), taskRec.getValue().intValue())) continue;
            if (fi.isLocked()) {
                this.logWithTaskId(taskRec.getTaskId(), "\u30d5\u30a1\u30a4\u30eb\u304c\u30ed\u30c3\u30af\u3055\u308c\u3066\u3044\u308b\u305f\u3081\u30b9\u30ad\u30c3\u30d7\u3057\u307e\u3059\uff1a" + fi.getFilePath());
                continue;
            }
            fromPathList.add(fi.getFilePath());
        }
    }

    private void expandToPath(Map<String, String> envVarInfoMap, ConnectionToRemoteServer connection, HousekeepFilesTaskRecord taskRec, AbstractTask task, List<String> toPathList) throws Exception {
        String varSubstitutedToPath = taskRec.getEnvVarExpandedDestPath();
        ArrayList<String> tmpToFileAndDirMixedList = null;
        if (!FileUtil.containsWildCard((String)varSubstitutedToPath)) {
            String dirPath;
            varSubstitutedToPath = FileUtil.cleanPathStrWithSlash((String)varSubstitutedToPath);
            tmpToFileAndDirMixedList = new ArrayList<String>();
            tmpToFileAndDirMixedList.add(varSubstitutedToPath);
            String string = dirPath = taskRec.getIsDestPathDir() != null && taskRec.getIsDestPathDir() == true ? varSubstitutedToPath : new File(varSubstitutedToPath).getParent();
            if (dirPath != null && !dirPath.startsWith("/")) {
                String dirPathTmp = dirPath.startsWith("./") ? dirPath.substring(2) : dirPath;
                dirPath = FileUtil.concatFilePaths((String[])new String[]{System.getProperty("user.dir"), dirPathTmp});
            }
        } else {
            tmpToFileAndDirMixedList = FileUtil.getPathListFromPathWithWildcard((String)varSubstitutedToPath);
        }
        for (String path : tmpToFileAndDirMixedList) {
            FileInfo dirInfo = task.getToPathFileInfo(task, connection, true, path);
            FileInfo fileInfo = task.getToPathFileInfo(task, connection, false, path);
            if (dirInfo == null && fileInfo == null) {
                toPathList.add(path);
                continue;
            }
            if ((dirInfo == null || !taskRec.getIsDestPathDir().booleanValue()) && (fileInfo == null || taskRec.getIsDestPathDir().booleanValue())) continue;
            toPathList.add(path);
        }
    }

    public List<AppException> logicalCheckTaskListAfterEnvVarExpansion(AbstractTask task, HousekeepFilesTaskRecord rec, HousekeepFilesExpandedPathsInfo pathInfo) throws BizLogicAppException {
        ArrayList<AppException> warnList = new ArrayList<AppException>();
        if (rec.getIsDestPathDir() != null && !rec.getIsDestPathDir().booleanValue() && pathInfo.fromFileList.size() > 1) {
            throw new BizLogicAppException("MSG_ERR_FROM_PATH_MUST_BE_ONLY_ONE_WHEN_TO_PATH_IS_FILE", new String[]{rec.getTaskId(), rec.getTaskName()});
        }
        if (rec.getSrcPath() != null && task.isSrcPathLocal() != null && task.isSrcPathLocal().booleanValue() && pathInfo.fromFileList.size() == 0) {
            if (rec.getActionForNoSrcPath() == IncidentTreatedAsEnum.ERROR) {
                throw new BizLogicAppException("MSG_ERR_FROM_PATH_NOT_EXIST", new String[]{rec.getTaskId(), rec.getTaskName(), rec.getSrcPath()});
            }
            if (rec.getActionForNoSrcPath() == IncidentTreatedAsEnum.WARN) {
                warnList.add((AppException)new BizLogicAppException("MSG_ERR_FROM_PATH_NOT_EXIST", new String[]{rec.getTaskId(), rec.getTaskName(), rec.getSrcPath()}));
            }
        }
        if (task.getInputRuleForDestPath() == TaskAttrCheckPtnEnum.REQUIRED) {
            if (task.isDestPathLocal().booleanValue()) {
                if (pathInfo.tmpToFileList.size() == 0) {
                    throw new BizLogicAppException("MSG_ERR_TO_PATH_DOESNT_EXIST", new String[]{rec.getTaskId(), rec.getTaskName()});
                }
                if (pathInfo.tmpToFileList.size() > 1) {
                    throw new BizLogicAppException("MSG_ERR_TO_PATH_NOT_ONE", new String[]{rec.getTaskId(), rec.getTaskName()});
                }
            }
            for (String fromPath : pathInfo.fromFileList) {
                String toPath;
                boolean doesFileOrDirExists = this.fmu.checkIfToOverwrittenFileOrDirExists(rec, fromPath, toPath = (String)pathInfo.tmpToFileList.get(0));
                if (!doesFileOrDirExists) continue;
                if (rec.getIsSrcPathDir().booleanValue() && rec.getIsDestPathDir().booleanValue()) {
                    throw new BizLogicAppException("MSG_ERR_TO_DIR_EXISTS_AND_COPY_SETTING_VAGUE", new String[]{rec.getTaskId(), rec.getTaskName()});
                }
                BizLogicAppException blEx = new BizLogicAppException("MSG_ERR_DEST_PATH_EXISTSS", new String[]{rec.getTaskId(), rec.getTaskName(), toPath});
                if (rec.getActionForDestFileExists() == IncidentTreatedAsEnum.ERROR) {
                    throw blEx;
                }
                if (rec.getActionForDestFileExists() != IncidentTreatedAsEnum.WARN) continue;
                warnList.add((AppException)blEx);
            }
        }
        return warnList;
    }

    public void doTaskForMultipleFiles(HousekeepFilesTaskRecord taskRec, HousekeepFilesExpandedPathsInfo pathInfo, ConnectionToRemoteServer conn, List<AppException> warnList) throws Exception {
        this.logTaskStartMsg(taskRec);
        AbstractTask task = this.getTaskInstance(taskRec);
        if (task.getTaskActionKind() == TaskActionKindEnum.create) {
            task.doTask(conn, taskRec, taskRec.getEnvVarExpandedSrcPath(), pathInfo.toPath, warnList);
        } else {
            for (String fromPath : pathInfo.fromFileList) {
                task.doTask(conn, taskRec, fromPath, pathInfo.toPath, warnList);
            }
        }
        this.logTaskFinishMsg(taskRec, pathInfo);
    }

    private void logTaskStartMsg(HousekeepFilesTaskRecord rec) throws BizLogicAppException {
        String taskId = rec.getTaskId();
        this.dlog.debug("### startTask  :" + taskId);
        this.logWithTaskId(taskId, "taskName              = " + rec.getTaskName());
        this.logWithTaskId(taskId, "taskPtn               = " + String.valueOf(rec.getTaskPtn()));
        this.logWithTaskId(taskId, "remoteServer          = " + rec.getRemoteServer());
        this.logWithTaskId(taskId, "pathFrom              = " + rec.getSrcPath());
        this.logWithTaskId(taskId, "isSrcPathDir         = " + rec.getIsSrcPathDir());
        this.logWithTaskId(taskId, "unit                  = " + rec.getUnit());
        this.logWithTaskId(taskId, "value                 = " + rec.getValue());
        this.logWithTaskId(taskId, "actionForNoSrcPath   = " + String.valueOf(rec.getActionForNoSrcPath()));
        this.logWithTaskId(taskId, "pathTo                = " + rec.getDestPath());
        this.logWithTaskId(taskId, "isDestPathDir           = " + rec.getIsDestPathDir());
        this.logWithTaskId(taskId, "doesOverwriteDestPath   = " + rec.getDoesOverwriteDestPath());
        this.logWithTaskId(taskId, "actionForToFileExists = " + String.valueOf(rec.getActionForDestFileExists()));
        this.logWithTaskId(taskId, "options               = " + rec.options);
    }

    private void logTaskFinishMsg(HousekeepFilesTaskRecord taskRec, HousekeepFilesExpandedPathsInfo pathInfo) {
        this.dlog.debug("### finishTask :" + taskRec.getTaskId() + " | \u51e6\u7406\u30d5\u30a1\u30a4\u30eb\uff0f\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u6570:" + pathInfo.fromFileList.size());
    }

    private void logWithTaskId(String taskId, String msg) {
        this.dlog.debug("[" + taskId + "] " + msg);
    }

    protected AbstractTask getTaskInstance(HousekeepFilesTaskRecord taskRec) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        String taskName = StringUtil.getUpperCamelFromSnake((String)taskRec.getTaskPtn().toString());
        Class<?> cls = Class.forName("jp.ecuacion.tool.housekeepfiles.bl.task." + taskName);
        AbstractTask task = (AbstractTask)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return task;
    }

    public void sendWarnMail(List<AppException> warnList, HousekeepFilesHdRecord hdE) throws Exception {
        ArrayList msgList = new ArrayList();
        for (AppException ae : warnList) {
            msgList.addAll(ExceptionUtil.getAppExceptionMessageList((AppException)ae, (Locale)Locale.JAPANESE));
        }
        String title = PropertyFileUtil.getApplication((String)"jp.ecuacion.lib.core.mail.title-prefix") + "[WARN] HousekeepFiles:" + hdE.getSysName();
        String hostname = InetAddress.getLocalHost().getHostName();
        StringBuilder msg = new StringBuilder();
        msg.append("hostname: " + hostname + "\n\nYou've got warnings: \n\n");
        for (String additionalMsg : msgList) {
            msg.append("- " + additionalMsg + "\n");
        }
        this.dlog.debug(msg.toString());
        ArrayList<String> mailTo = new ArrayList<String>();
        for (String to : PropertyFileUtil.getApplication((String)"jp.ecuacion.lib.core.mail.address-csv-on-system-error").split(",")) {
            mailTo.add(to);
        }
        MailUtil.sendMail(mailTo, null, (String)title, (String)msg.toString());
    }
}

