/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.tool.housekeepfiles.dto.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.tool.housekeepfiles.dto.record.HousekeepFilesAuthRecord;
import jp.ecuacion.tool.housekeepfiles.dto.record.HousekeepFilesHdRecord;
import jp.ecuacion.tool.housekeepfiles.dto.record.HousekeepFilesPathRecord;
import jp.ecuacion.tool.housekeepfiles.dto.record.HousekeepFilesTaskRecord;
import jp.ecuacion.tool.housekeepfiles.reader.ExcelInfoListReader;
import jp.ecuacion.util.poi.excel.table.bean.StringExcelTableBean;
import jp.ecuacion.util.poi.excel.table.reader.concrete.StringOneLineHeaderExcelTableToBeanReader;
import org.apache.poi.EncryptedDocumentException;

public class HousekeepFilesForm {
    private Map<String, String> infoMap;
    private HousekeepFilesHdRecord taskInfoHdRec = null;
    private List<HousekeepFilesPathRecord> pathInfoRecList = null;
    private List<HousekeepFilesAuthRecord> authInfoRecList = null;
    private static final String[] HEADER_LABELS_TASK = new String[]{"\u30bf\u30b9\u30afID", "\u30bf\u30b9\u30af\u540d", "\u51e6\u7406\u30d1\u30bf\u30fc\u30f3\n\u65e5\u672c\u8a9e\u540d", "\u51e6\u7406\u30d1\u30bf\u30fc\u30f3", "\u63a5\u7d9a\u5148\u30b5\u30fc\u30d0", "\u5143\u30d1\u30b9", "\u5143\u30d1\u30b9\u304c\u30c7\u30a3\u30ec\u30af\u30c8\u30ea", "\u5143\u30d1\u30b9\u51e6\u7406\u5b9f\u65bd\u5bfe\u8c61\n\u7d4c\u904e\u671f\u9593\u5358\u4f4d", "\u5143\u30d1\u30b9\u51e6\u7406\u5b9f\u65bd\u5bfe\u8c61\n\u7d4c\u904e\u671f\u9593\u5024", "\u5143\u30d1\u30b9\u5b58\u5728\u306a\u3057\u6642\u51e6\u7406", "\u5148\u30d1\u30b9", "\u5148\u30d1\u30b9\u304c\u30c7\u30a3\u30ec\u30af\u30c8\u30ea", "\u5148\u30d1\u30b9\u5b58\u5728\u6642\u4e0a\u66f8\u304d", "\u5148\u30d1\u30b9\u5b58\u5728\u6642\u51e6\u7406", "options"};
    private static final String[] HEADER_LABELS_PATH = new String[]{"\u30d1\u30b9\u5909\u6570\u540d", "\u30d1\u30b9\u5024"};
    private static final String[] HEADER_LABELS_AUTH = new String[]{"\u30b5\u30fc\u30d0\u540d", "protocol", "port", "\u8a8d\u8a3c\u65b9\u5f0f", "\u30e6\u30fc\u30b6\u540d", "password / passphrase", "\u79d8\u5bc6\u9375\u30d1\u30b9"};

    public HousekeepFilesForm() {
        this.taskInfoHdRec = new HousekeepFilesHdRecord();
        this.pathInfoRecList = new ArrayList();
        this.authInfoRecList = new ArrayList();
    }

    public HousekeepFilesForm(String excelPath) throws AppException {
        this.readExcel(excelPath);
    }

    protected void readExcel(String excelPath) throws AppException {
        try {
            this.infoMap = new ExcelInfoListReader().readToMap(excelPath);
            this.taskInfoHdRec = new HousekeepFilesHdRecord();
            this.taskInfoHdRec.setSysName((String)this.infoMap.get("env-name"));
            this.taskInfoHdRec.recList = new StringOneLineHeaderExcelTableToBeanReader(HousekeepFilesTaskRecord.class, "\u30bf\u30b9\u30af\u8a2d\u5b9a", HEADER_LABELS_TASK, null, 1, null, (StringExcelTableBean[])new HousekeepFilesTaskRecord[0]).ignoresAdditionalColumnsOfHeaderData(true).readToBean(excelPath);
            this.pathInfoRecList = new StringOneLineHeaderExcelTableToBeanReader(HousekeepFilesPathRecord.class, "\u30d1\u30b9\u8a2d\u5b9a", HEADER_LABELS_PATH, null, 1, null, (StringExcelTableBean[])new HousekeepFilesPathRecord[0]).readToBean(excelPath);
            this.authInfoRecList = new StringOneLineHeaderExcelTableToBeanReader(HousekeepFilesAuthRecord.class, "\u30b5\u30fc\u30d0\u8a8d\u8a3c\u8a2d\u5b9a", HEADER_LABELS_AUTH, null, 1, null, (StringExcelTableBean[])new HousekeepFilesAuthRecord[0]).readToBean(excelPath);
        }
        catch (IOException | EncryptedDocumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Map<String, String> getInfoMap() {
        return this.infoMap;
    }

    public HousekeepFilesHdRecord getTaskInfoHdRec() {
        return this.taskInfoHdRec;
    }

    public List<HousekeepFilesPathRecord> getPathInfoRecList() {
        return this.pathInfoRecList;
    }

    public List<HousekeepFilesAuthRecord> getAuthInfoRecList() {
        return this.authInfoRecList;
    }
}

