/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.tool.housekeepfiles.dto.record;

import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.Arrays;
import java.util.List;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.tool.housekeepfiles.enums.AuthTypeEnum;
import jp.ecuacion.util.poi.excel.table.bean.StringExcelTableBean;

public class HousekeepFilesAuthRecord
extends StringExcelTableBean {
    @NotEmpty
    @Size(min=1, max=40)
    @Pattern(regexp="^[^!\"#\\$%&'\\(\\)=\\^~\\\\\\|`\\[\\{;\\+:\\\\*\\]\\},<>/\\?]*$")
    private @NotEmpty @Size(min=1, max=40) @Pattern(regexp="^[^!\"#\\$%&'\\(\\)=\\^~\\\\\\|`\\[\\{;\\+:\\\\*\\]\\},<>/\\?]*$") String remoteServer;
    @NotEmpty
    private String protocol;
    @NotEmpty
    @DecimalMin(value="0")
    @DecimalMax(value="99999")
    private @NotEmpty @DecimalMin(value="0") @DecimalMax(value="99999") String port;
    @NotEmpty
    private String authType;
    @Size(min=1, max=40)
    @Pattern(regexp="^[^!\"#\\$%&'\\(\\)=\\^~\\\\\\|`\\[\\{;\\+:\\\\*\\]\\},<>/\\?]*$")
    private @Size(min=1, max=40) @Pattern(regexp="^[^!\"#\\$%&'\\(\\)=\\^~\\\\\\|`\\[\\{;\\+:\\\\*\\]\\},<>/\\?]*$") String userName;
    @Size(min=1, max=30)
    private @Size(min=1, max=30) String password;
    @Size(min=1, max=300)
    private @Size(min=1, max=300) String keyPath;

    @Nonnull
    protected String[] getFieldNameArray() {
        return new String[]{"remoteServer", "protocol", "port", "authType", "userName", "password", "keyPath"};
    }

    public HousekeepFilesAuthRecord(List<String> colList) {
        super(colList);
    }

    public HousekeepFilesAuthRecord(String remoteServer, String protocol, String port, String authType, String userName, String password, String keyPath) {
        super(Arrays.asList(remoteServer, protocol, port, authType, userName, password, keyPath));
    }

    public String getRemoteServer() {
        return this.remoteServer;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getPort() {
        return Integer.parseInt(this.port);
    }

    public AuthTypeEnum getAuthType() {
        return AuthTypeEnum.valueOf((String)this.authType);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getKeyPath() {
        return this.keyPath;
    }

    public void afterReading() throws AppException {
    }
}

