/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.tool.housekeepfiles.bl.task;

import java.io.File;
import java.util.List;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.util.FileUtil;
import jp.ecuacion.tool.housekeepfiles.bean.ConnectionToRemoteServer;
import jp.ecuacion.tool.housekeepfiles.bl.task.AbstractTaskLocal;
import jp.ecuacion.tool.housekeepfiles.dto.record.HousekeepFilesTaskRecord;
import jp.ecuacion.tool.housekeepfiles.util.CompressUtil;
import org.apache.commons.io.FileUtils;

public abstract class AbstractTaskZip
extends AbstractTaskLocal {
    protected void doTaskInternal(ConnectionToRemoteServer connection, HousekeepFilesTaskRecord taskRec, String fromPath, String toPath, List<AppException> warnList) throws AppException {
        CompressUtil cu = new CompressUtil();
        File from = new File(fromPath);
        String toFilePath = null;
        if (taskRec.getIsDestPathDir() == null) {
            File toDir = from.getParentFile();
            toFilePath = FileUtil.concatFilePaths((String[])new String[]{toDir.getAbsolutePath(), from.getName() + ".zip"});
        } else {
            String string = toFilePath = taskRec.getIsDestPathDir() != false ? FileUtil.concatFilePaths((String[])new String[]{toPath, from.getName() + ".zip"}) : toPath;
        }
        if (new File(toFilePath).exists()) {
            this.treatDestPathExists(taskRec, taskRec.getSrcPath() + ".zip", warnList);
            return;
        }
        try {
            if (from.isDirectory()) {
                cu.zipDirectory(fromPath, toFilePath);
            } else {
                cu.zipFile(fromPath, toFilePath);
            }
        }
        catch (Exception e) {
            this.dlog.debug("\u30d5\u30a1\u30a4\u30eb\u304c\u30ed\u30c3\u30af\u3055\u308c\u3066\u3044\u308b\u305f\u3081\u30b9\u30ad\u30c3\u30d7\u3057\u307e\u3059\uff1a" + fromPath);
            e.printStackTrace();
            return;
        }
        if (this.getClass().getSimpleName().contains("DeleteOrig")) {
            try {
                File fromFile = new File(fromPath);
                if (fromFile.isDirectory()) {
                    FileUtils.deleteDirectory((File)new File(fromPath));
                } else {
                    fromFile.delete();
                }
            }
            catch (Exception e) {
                this.dlog.debug("zip\u5143\u30d5\u30a1\u30a4\u30eb\u304c\u30ed\u30c3\u30af\u3055\u308c\u3066\u3044\u308b\u305f\u3081\u30b9\u30ad\u30c3\u30d7\u3057\u307e\u3059\uff1a" + fromPath);
            }
        }
    }
}

