/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.tool.housekeepfiles.bl.task;

import java.io.File;
import java.util.List;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.exception.checked.SingleAppException;
import jp.ecuacion.lib.core.util.FileUtil;
import jp.ecuacion.tool.housekeepfiles.bean.ConnectionToRemoteServer;
import jp.ecuacion.tool.housekeepfiles.bl.task.AbstractTaskLocal;
import jp.ecuacion.tool.housekeepfiles.dto.record.HousekeepFilesTaskRecord;
import jp.ecuacion.tool.housekeepfiles.enums.TaskActionKindEnum;
import jp.ecuacion.tool.housekeepfiles.enums.TaskPtnEnum;
import jp.ecuacion.tool.housekeepfiles.util.HkFileManipulateUtil;

public abstract class AbstractTaskCopyOrMove
extends AbstractTaskLocal {
    private HkFileManipulateUtil fmu = new HkFileManipulateUtil();

    public TaskActionKindEnum getTaskActionKind() {
        return TaskActionKindEnum.change;
    }

    protected abstract void doSpecificTask(HousekeepFilesTaskRecord var1, String var2, String var3, TaskPtnEnum var4, boolean var5, boolean var6);

    public void taskDependentCheck(HousekeepFilesTaskRecord taskRec, List<SingleAppException> exList) {
    }

    protected void doTaskInternal(ConnectionToRemoteServer connection, HousekeepFilesTaskRecord taskRec, String srcPath, String destPath, List<AppException> warnList) throws BizLogicAppException {
        boolean isToDir;
        TaskPtnEnum taskPtn = taskRec.getTaskPtn();
        boolean doesOverwrittenFileOrDirExist = true;
        try {
            doesOverwrittenFileOrDirExist = this.fmu.checkIfToOverwrittenFileOrDirExists(taskRec, srcPath, destPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        boolean isFromDir = taskRec.getIsSrcPathDir() == true;
        boolean bl = isToDir = taskRec.getIsDestPathDir() == true;
        if (doesOverwrittenFileOrDirExist) {
            if (!taskRec.getDoesOverwriteDestPath().booleanValue()) {
                return;
            }
            String toFilePath = isToDir ? FileUtil.concatFilePaths((String[])new String[]{destPath, new File(srcPath).getName()}) : destPath;
            new File(toFilePath).delete();
        }
        this.doSpecificTask(taskRec, srcPath, destPath, taskPtn, isFromDir, isToDir);
    }
}

