/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.tool.housekeepfiles.util;

import java.util.Map;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;

public class ParameterUtil {
    public String getFirstUnixEnvVar(String str) throws BizLogicAppException {
        int pathVarStartIndex = 0;
        int pathVarEndIndex = 0;
        pathVarStartIndex = str.indexOf("${");
        pathVarEndIndex = str.indexOf("}");
        if (pathVarEndIndex <= 0) {
            return null;
        }
        if (pathVarStartIndex > pathVarEndIndex) {
            throw new BizLogicAppException("MSG_ERR_UNIX_ENV_FORMAT_INCORRECT", new String[]{str});
        }
        return str.substring(pathVarStartIndex + 2, pathVarEndIndex);
    }

    public String substituteUnixEnvVars(String str, Map<String, String> map) throws BizLogicAppException {
        String var = null;
        while ((var = this.getFirstUnixEnvVar(str)) != null) {
            if (!map.containsKey(var)) {
                throw new BizLogicAppException("MSG_ERR_MAP_DOESNT_CONTAIN_PARAM_KEY", new String[]{var});
            }
            str = str.replace("${" + var + "}", map.get(var));
        }
        return str;
    }
}

