/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.tool.housekeepfiles.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class CompressUtil {
    public void zipDirectory(String fromDirPath, String toFilePath) throws IOException {
        this.zipDirectory(fromDirPath, toFilePath, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zipDirectory(String fromDirPath, String toFilePath, String encoding) throws IOException {
        File baseFile = new File(toFilePath);
        File file = new File(fromDirPath);
        ZipOutputStream outZip = null;
        try {
            outZip = new ZipOutputStream((OutputStream)new FileOutputStream(baseFile), Charset.forName(encoding));
            this.archive(outZip, baseFile, file);
        }
        finally {
            if (outZip != null) {
                try {
                    outZip.closeEntry();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                try {
                    outZip.flush();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                try {
                    outZip.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void zipFile(String fromFilePath, String toFilePath) throws IOException {
        this.zipFile(fromFilePath, toFilePath, "UTF-8");
    }

    public void zipFile(String fromFilePath, String toFilePath, String encoding) throws IOException {
        ArrayList<String> arr = new ArrayList<String>();
        arr.add(fromFilePath);
        this.zipFileList(arr, toFilePath, encoding);
    }

    public void zipFileList(List<String> fromFileList, String filePath) throws IOException {
        this.zipFileList(fromFileList, filePath, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zipFileList(List<String> fromFileList, String filePath, String encoding) throws IOException {
        ZipOutputStream outZip = null;
        File baseFile = new File(filePath);
        try {
            outZip = new ZipOutputStream((OutputStream)new FileOutputStream(baseFile), Charset.forName(encoding));
            for (int i = 0; i < fromFileList.size(); ++i) {
                File file = new File(fromFileList.get(i));
                this.archive(outZip, file, file.getName());
            }
        }
        finally {
            if (outZip != null) {
                try {
                    outZip.closeEntry();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                try {
                    outZip.flush();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                try {
                    outZip.close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void archive(ZipOutputStream outZip, File baseFile, File targetFile) throws IOException {
        if (targetFile.isDirectory()) {
            File[] files;
            for (File f : files = targetFile.listFiles()) {
                if (f.isDirectory()) {
                    this.archive(outZip, f, f.getAbsolutePath().replace(baseFile.getParent(), "").substring(1));
                    this.archive(outZip, baseFile, f);
                    continue;
                }
                if (f.getAbsoluteFile().equals(baseFile)) continue;
                this.archive(outZip, f, f.getAbsolutePath().replace(baseFile.getParent(), "").substring(1));
            }
        }
    }

    private void archive(ZipOutputStream outZip, File targetFile, String entryName) throws IOException {
        outZip.setLevel(5);
        Object entryNameForZipUtil = targetFile.isDirectory() ? entryName + "/" : entryName;
        ZipEntry ze = new ZipEntry((String)entryNameForZipUtil);
        ze.setTime(targetFile.lastModified());
        outZip.putNextEntry(ze);
        if (!targetFile.isDirectory()) {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(targetFile));
            int readSize = 0;
            byte[] buffer = new byte[1024];
            while ((readSize = in.read(buffer, 0, buffer.length)) != -1) {
                outZip.write(buffer, 0, readSize);
            }
            in.close();
        }
        outZip.closeEntry();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unzip(String fromFullFilePath, String toFullDirPath) throws IOException {
        try (ZipFile zf = new ZipFile(fromFullFilePath);){
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                if (ze.isDirectory()) {
                    new File(toFullDirPath + ze.getName()).mkdirs();
                    continue;
                }
                try {
                    InputStream input = zf.getInputStream(ze);
                    try (FileOutputStream output = new FileOutputStream(toFullDirPath + ze.getName());){
                        int len;
                        byte[] buf = new byte[256];
                        while ((len = input.read(buf)) != -1) {
                            output.write(buf, 0, len);
                        }
                    }
                    finally {
                        if (input == null) continue;
                        input.close();
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                    return;
                }
            }
        }
    }
}

