/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.tool.housekeepfiles.dto.record;

import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.jakartavalidation.validator.BooleanString;
import jp.ecuacion.lib.core.jakartavalidation.validator.EnumElement;
import jp.ecuacion.lib.core.jakartavalidation.validator.IntegerString;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import jp.ecuacion.tool.housekeepfiles.bl.task.AbstractTask;
import jp.ecuacion.tool.housekeepfiles.enums.IncidentTreatedAsEnum;
import jp.ecuacion.tool.housekeepfiles.enums.TaskPtnEnum;
import jp.ecuacion.tool.housekeepfiles.util.ParameterUtil;
import jp.ecuacion.util.poi.excel.table.bean.StringExcelTableBean;
import org.apache.commons.lang3.StringUtils;

public class HousekeepFilesTaskRecord
extends StringExcelTableBean {
    private ParameterUtil pu = new ParameterUtil();
    @NotEmpty
    @Size(min=1, max=10)
    @Pattern.List(value={@Pattern(regexp="^[a-zA-Z0-9 -/:-@\\[-\\`\\{-\\~]*$"), @Pattern(regexp="^[^!\"#\\$%&'\\(\\)=\\^~\\\\\\|`\\[\\{;\\+:\\\\*\\]\\},<>/\\?]*$")})
    private @NotEmpty @Size(min=1, max=10) @Pattern.List(value={@Pattern(regexp="^[a-zA-Z0-9 -/:-@\\[-\\`\\{-\\~]*$"), @Pattern(regexp="^[^!\"#\\$%&'\\(\\)=\\^~\\\\\\|`\\[\\{;\\+:\\\\*\\]\\},<>/\\?]*$")}) String taskId;
    @NotEmpty
    @Size(min=1, max=40)
    @Pattern(regexp="^[^!\"#\\$%&'\\(\\)=\\^~\\\\\\|`\\[\\{;\\+:\\\\*\\]\\},<>/\\?]*$")
    private @NotEmpty @Size(min=1, max=40) @Pattern(regexp="^[^!\"#\\$%&'\\(\\)=\\^~\\\\\\|`\\[\\{;\\+:\\\\*\\]\\},<>/\\?]*$") String taskName;
    @NotEmpty
    @EnumElement(enumPackage="jp.ecuacion.tool.housekeepfiles.enums", enumClass="TaskPtnEnum")
    public String taskPtnEnumName;
    @Size(min=1, max=40)
    @Pattern(regexp="^[^!\"#\\$%&'\\(\\)=\\^~\\\\\\|`\\[\\{;\\+:\\\\*\\]\\},<>/\\?]*$")
    private @Size(min=1, max=40) @Pattern(regexp="^[^!\"#\\$%&'\\(\\)=\\^~\\\\\\|`\\[\\{;\\+:\\\\*\\]\\},<>/\\?]*$") String remoteServer;
    @BooleanString
    public String isSrcPathDirEnumName;
    @Size(min=1, max=300)
    private @Size(min=1, max=300) String srcPath;
    @Pattern(regexp="DAY")
    public @Pattern(regexp="DAY") String unitName;
    @IntegerString
    @DecimalMin(value="0")
    @DecimalMax(value="1000")
    private @DecimalMin(value="0") @DecimalMax(value="1000") String value;
    @EnumElement(enumPackage="jp.ecuacion.tool.housekeepfiles.enums", enumClass="IncidentTreatedAsEnum")
    public String actionForNoSrcPathEnumName;
    @Size(min=1, max=300)
    @Pattern(regexp="^[^*?]*$")
    private @Size(min=1, max=300) @Pattern(regexp="^[^*?]*$") String destPath;
    @BooleanString
    public String isDestPathDirEnumName;
    @BooleanString
    public String doesOverwriteDestPathEnumName;
    @EnumElement(enumPackage="jp.ecuacion.tool.housekeepfiles.enums", enumClass="IncidentTreatedAsEnum")
    public String actionForDestFileExistsEnumName;
    public String options;
    private String envVarExpandedSrcPath;
    private String envVarExpandedDestPath;
    private Map<String, String> envVarInfoMap;
    public AbstractTask task;

    @Nonnull
    protected String[] getFieldNameArray() {
        return new String[]{"taskId", "taskName", null, "taskPtnEnumName", "remoteServer", "srcPath", "isSrcPathDirEnumName", "unitName", "value", "actionForNoSrcPathEnumName", "destPath", "isDestPathDirEnumName", "doesOverwriteDestPathEnumName", "actionForDestFileExistsEnumName", "options"};
    }

    public HousekeepFilesTaskRecord(String taskId, String taskName, String taskPtnEnumName, String remoteServer, String pathFrom, String isSrcPathDirEnumName, String unitName, String value, String actionForNoSrcPathEnumName, String pathTo, String isDestPathDirEnumName, String doesOverwriteDestPathEnumName, String actionForDestFileExistsEnumName, String options) {
        super(Arrays.asList(taskId, taskName, null, taskPtnEnumName, remoteServer, pathFrom, isSrcPathDirEnumName, unitName, value, actionForNoSrcPathEnumName, pathTo, isDestPathDirEnumName, doesOverwriteDestPathEnumName, actionForDestFileExistsEnumName, options));
    }

    public HousekeepFilesTaskRecord(List<String> colList) {
        super(colList);
    }

    public Integer getUnit() {
        int rtn = -1;
        if (this.unitName == null || this.unitName.equals("")) {
            return null;
        }
        if (this.unitName.equals("YEAR")) {
            rtn = 1;
        } else if (this.unitName.equals("MONTH")) {
            rtn = 2;
        } else if (this.unitName.equals("DAY")) {
            rtn = 5;
        } else if (this.unitName.equals("HOUR")) {
            rtn = 10;
        } else if (this.unitName.equals("MINUTE")) {
            rtn = 12;
        } else if (this.unitName.equals("SECOND")) {
            rtn = 13;
        } else {
            throw new RuntimeException("Not exist unit value: " + this.unitName);
        }
        return rtn;
    }

    public void setUnit(String unit) {
        throw new RuntimeException("Unit cannot be set. set 'unitName'.");
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public TaskPtnEnum getTaskPtn() {
        return TaskPtnEnum.valueOf((String)this.taskPtnEnumName);
    }

    public String getRemoteServer() {
        return this.remoteServer;
    }

    public Boolean getIsSrcPathDir() throws BizLogicAppException {
        return StringUtils.isEmpty((CharSequence)this.isSrcPathDirEnumName) ? null : Boolean.valueOf(this.isSrcPathDirEnumName.toLowerCase());
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    public Boolean getIsDestPathDir() {
        return StringUtils.isEmpty((CharSequence)this.isDestPathDirEnumName) ? null : Boolean.valueOf(this.isDestPathDirEnumName.toLowerCase());
    }

    public String getDestPath() {
        return this.destPath;
    }

    public Integer getValue() {
        return this.value == null ? null : Integer.valueOf(this.value);
    }

    public IncidentTreatedAsEnum getActionForNoSrcPath() {
        return this.actionForNoSrcPathEnumName == null ? null : IncidentTreatedAsEnum.valueOf((String)this.actionForNoSrcPathEnumName);
    }

    public Boolean getDoesOverwriteDestPath() {
        return StringUtils.isEmpty((CharSequence)this.doesOverwriteDestPathEnumName) ? null : Boolean.valueOf(this.doesOverwriteDestPathEnumName.toLowerCase());
    }

    public IncidentTreatedAsEnum getActionForDestFileExists() {
        return StringUtils.isEmpty((CharSequence)this.actionForDestFileExistsEnumName) ? null : IncidentTreatedAsEnum.valueOf((String)this.actionForDestFileExistsEnumName);
    }

    public String getEnvVarExpandedSrcPath() {
        if (this.envVarInfoMap == null) {
            throw new RuntimeException("envVarInfoMap must be set before call the method.");
        }
        return this.envVarExpandedSrcPath;
    }

    public String getEnvVarExpandedDestPath() {
        if (this.envVarInfoMap == null) {
            throw new RuntimeException("envVarInfoMap must be set before call the method.");
        }
        return this.envVarExpandedDestPath;
    }

    public void setEnvVarInfoMap(Map<String, String> envVarInfoMap) throws BizLogicAppException {
        if (envVarInfoMap == null) {
            envVarInfoMap = new HashMap<String, String>();
        }
        this.envVarInfoMap = envVarInfoMap;
        this.envVarExpandedSrcPath = this.srcPath == null ? null : this.substituteEnvVars(this.srcPath);
        this.envVarExpandedDestPath = this.destPath == null ? null : this.substituteEnvVars(this.destPath);
    }

    private String substituteEnvVars(String path) throws BizLogicAppException {
        String envVarExpandedPath = this.pu.substituteUnixEnvVars(path, this.envVarInfoMap);
        while (envVarExpandedPath.contains("//")) {
            envVarExpandedPath = envVarExpandedPath.replace("//", "/");
        }
        return envVarExpandedPath;
    }

    public void afterReading() throws AppException {
        boolean isAllEmpty = StringUtils.isEmpty((CharSequence)this.srcPath) && StringUtils.isEmpty((CharSequence)this.isSrcPathDirEnumName) && StringUtils.isEmpty((CharSequence)this.unitName) && StringUtils.isEmpty((CharSequence)this.value) && StringUtils.isEmpty((CharSequence)this.actionForNoSrcPathEnumName);
        boolean isAllNotEmpty = !StringUtils.isEmpty((CharSequence)this.srcPath) && !StringUtils.isEmpty((CharSequence)this.isSrcPathDirEnumName) && !StringUtils.isEmpty((CharSequence)this.unitName) && !StringUtils.isEmpty((CharSequence)this.value) && !StringUtils.isEmpty((CharSequence)this.actionForNoSrcPathEnumName);
        String[] lbls = new String[]{"srcPath", "isSrcPathDir", "unit", "value", "actionForNoSrcPath"};
        if (!isAllEmpty && !isAllNotEmpty) {
            throw new BizLogicAppException("MSG_ERR_FIELDS_ARE_EITHER_ALL_EMPTY_OR_ALL_NOT_EMPTY", new String[]{this.getLabelNameCsv(lbls)});
        }
        isAllEmpty = StringUtils.isEmpty((CharSequence)this.destPath) && StringUtils.isEmpty((CharSequence)this.isDestPathDirEnumName) && StringUtils.isEmpty((CharSequence)this.doesOverwriteDestPathEnumName) && StringUtils.isEmpty((CharSequence)this.actionForDestFileExistsEnumName);
        isAllNotEmpty = !StringUtils.isEmpty((CharSequence)this.destPath) && !StringUtils.isEmpty((CharSequence)this.isDestPathDirEnumName) && !StringUtils.isEmpty((CharSequence)this.doesOverwriteDestPathEnumName) && !StringUtils.isEmpty((CharSequence)this.actionForDestFileExistsEnumName);
        lbls = new String[]{"destPath", "isDestPathDir", "doesOverwriteDestPath", "actionForToFileExists"};
        if (!isAllEmpty && !isAllNotEmpty) {
            throw new BizLogicAppException("MSG_ERR_FIELDS_ARE_EITHER_ALL_EMPTY_OR_ALL_NOT_EMPTY", new String[]{this.getLabelNameCsv(lbls)});
        }
    }

    private String getLabelNameCsv(String[] itemIds) {
        StringBuilder sb = new StringBuilder();
        boolean is1st = true;
        for (String itemId : itemIds) {
            if (is1st) {
                is1st = false;
            } else {
                sb.append(", ");
            }
            sb.append(PropertyFileUtil.getItemName((String)("HousekeepFilesTask." + itemId)));
        }
        return sb.toString();
    }
}

