/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.tool.housekeepfiles.dto.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.tool.housekeepfiles.dto.record.HousekeepFilesAuthRecord;
import jp.ecuacion.tool.housekeepfiles.dto.record.HousekeepFilesHdRecord;
import jp.ecuacion.tool.housekeepfiles.dto.record.HousekeepFilesPathRecord;
import jp.ecuacion.tool.housekeepfiles.reader.ExcelAuthListReader;
import jp.ecuacion.tool.housekeepfiles.reader.ExcelInfoListReader;
import jp.ecuacion.tool.housekeepfiles.reader.ExcelPathListReader;
import jp.ecuacion.tool.housekeepfiles.reader.ExcelTaskListReader;
import org.apache.poi.EncryptedDocumentException;

public class HousekeepFilesForm {
    private Map<String, String> infoMap;
    private HousekeepFilesHdRecord taskInfoHdRec = null;
    private List<HousekeepFilesPathRecord> pathInfoRecList = null;
    private List<HousekeepFilesAuthRecord> authInfoRecList = null;

    public HousekeepFilesForm() {
        this.taskInfoHdRec = new HousekeepFilesHdRecord();
        this.pathInfoRecList = new ArrayList();
        this.authInfoRecList = new ArrayList();
    }

    public HousekeepFilesForm(String excelPath) throws AppException {
        this.readExcel(excelPath);
    }

    protected void readExcel(String excelPath) throws AppException {
        try {
            this.infoMap = new ExcelInfoListReader().readToMap(excelPath);
            this.taskInfoHdRec = new HousekeepFilesHdRecord();
            this.taskInfoHdRec.setSysName((String)this.infoMap.get("env-name"));
            this.taskInfoHdRec.recList = ((ExcelTaskListReader)new ExcelTaskListReader().ignoresAdditionalColumnsOfHeaderData(true)).readToBean(excelPath);
            this.pathInfoRecList = new ExcelPathListReader().readToBean(excelPath);
            this.authInfoRecList = new ExcelAuthListReader().readToBean(excelPath);
        }
        catch (IOException | EncryptedDocumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Map<String, String> getInfoMap() {
        return this.infoMap;
    }

    public HousekeepFilesHdRecord getTaskInfoHdRec() {
        return this.taskInfoHdRec;
    }

    public List<HousekeepFilesPathRecord> getPathInfoRecList() {
        return this.pathInfoRecList;
    }

    public List<HousekeepFilesAuthRecord> getAuthInfoRecList() {
        return this.authInfoRecList;
    }
}

