/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.tool.housekeepfiles.bl.task;

import java.io.File;
import jp.ecuacion.tool.housekeepfiles.bl.task.AbstractTaskCopyOrMove;
import jp.ecuacion.tool.housekeepfiles.dto.record.HousekeepFilesTaskRecord;
import jp.ecuacion.tool.housekeepfiles.enums.TaskPtnEnum;
import jp.ecuacion.tool.housekeepfiles.util.DateTimeUtil;
import org.apache.commons.io.FileUtils;

public class Move
extends AbstractTaskCopyOrMove {
    private DateTimeUtil dateUtil = new DateTimeUtil();

    public Move() {
        this.taskPtn = TaskPtnEnum.MOVE;
    }

    protected void doSpecificTask(HousekeepFilesTaskRecord taskRec, String fromPath, String toPath, TaskPtnEnum taskPtn, boolean isFromDir, boolean isToDir) {
        File from = new File(fromPath);
        File to = new File(toPath);
        if (isFromDir) {
            String newToPath = this.fu.concatFilePaths(new String[]{to.getAbsolutePath(), from.getName()});
            try {
                FileUtils.moveDirectory((File)from, (File)new File(newToPath));
            }
            catch (Exception e) {
                this.dlog.debug("\u30d5\u30a1\u30a4\u30eb\u304c\u30ed\u30c3\u30af\u3055\u308c\u3066\u3044\u308b\u305f\u3081\u30b9\u30ad\u30c3\u30d7\u3057\u307e\u3059\uff1a" + String.valueOf(from));
                e.printStackTrace();
            }
        } else if (this.dateUtil.hasDesignatedTermPassed(from.lastModified(), taskRec.getUnit().intValue(), taskRec.getValue().intValue())) {
            try {
                if (isToDir) {
                    FileUtils.moveFileToDirectory((File)from, (File)to, (boolean)true);
                } else {
                    FileUtils.moveFile((File)from, (File)to);
                }
            }
            catch (Exception e) {
                this.dlog.debug("\u30d5\u30a1\u30a4\u30eb\u304c\u30ed\u30c3\u30af\u3055\u308c\u3066\u3044\u308b\u305f\u3081\u30b9\u30ad\u30c3\u30d7\u3057\u307e\u3059\uff1a" + String.valueOf(from));
                e.printStackTrace();
            }
        }
    }
}

