/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.tool.housekeepfiles.bl.task;

import java.io.File;
import java.util.List;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.exception.checked.SingleAppException;
import jp.ecuacion.tool.housekeepfiles.bean.ConnectionToRemoteServer;
import jp.ecuacion.tool.housekeepfiles.bl.task.AbstractTaskLocal;
import jp.ecuacion.tool.housekeepfiles.bl.task.internal.CreateDirInterface;
import jp.ecuacion.tool.housekeepfiles.dto.record.HousekeepFilesTaskRecord;
import jp.ecuacion.tool.housekeepfiles.enums.TaskActionKindEnum;
import jp.ecuacion.tool.housekeepfiles.enums.TaskPtnEnum;

public class CreateDir
extends AbstractTaskLocal
implements CreateDirInterface {
    public CreateDir() {
        this.taskPtn = TaskPtnEnum.CREATE_FILE;
    }

    public TaskActionKindEnum getTaskActionKind() {
        return TaskActionKindEnum.create;
    }

    public void taskDependentCheck(HousekeepFilesTaskRecord taskRec, List<SingleAppException> exList) {
        this.taskDependentCheckCreateDir(exList, taskRec);
    }

    protected void doTaskInternal(ConnectionToRemoteServer conn, HousekeepFilesTaskRecord taskRec, String srcPath, String destPath, List<AppException> warnList) throws Exception {
        File dest = new File(destPath);
        if (dest.exists() && dest.isDirectory()) {
            this.treatDestPathExists(taskRec, destPath, warnList);
            return;
        }
        if (dest.exists() && !dest.isDirectory()) {
            throw new BizLogicAppException("MSG_ERR_DEST_PATH_IS_FILE", new String[]{taskRec.getTaskId(), taskRec.getTaskName(), destPath});
        }
        new File(destPath).mkdirs();
    }
}

