/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.tool.housekeepfiles.bl.task;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.stream.Collectors;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.tool.housekeepfiles.bean.ConnectionToRemoteServer;
import jp.ecuacion.tool.housekeepfiles.bean.ConnectionToSftpServer;
import jp.ecuacion.tool.housekeepfiles.bl.task.AbstractTask;
import jp.ecuacion.tool.housekeepfiles.bl.task.AbstractTaskRemote;
import jp.ecuacion.tool.housekeepfiles.dto.other.FileInfo;
import jp.ecuacion.tool.housekeepfiles.dto.record.HousekeepFilesAuthRecord;
import jp.ecuacion.tool.housekeepfiles.dto.record.HousekeepFilesTaskRecord;
import jp.ecuacion.tool.housekeepfiles.enums.AuthTypeEnum;
import jp.ecuacion.tool.housekeepfiles.enums.TaskActionKindEnum;

public abstract class AbstractTaskSftp
extends AbstractTaskRemote {
    public String getConnectionProtocol() {
        return "SFTP";
    }

    protected abstract void doSpecificTask(ConnectionToRemoteServer var1, HousekeepFilesTaskRecord var2, String var3, String var4, List<AppException> var5) throws Exception;

    protected void doTaskInternal(ConnectionToRemoteServer connection, HousekeepFilesTaskRecord taskRec, String fromPath, String toPath, List<AppException> warnList) {
        try {
            this.doSpecificTask(connection, taskRec, fromPath, toPath, warnList);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ConnectionToSftpServer getConnection(String remoteHost, Map<String, HousekeepFilesAuthRecord> authMap) throws Exception {
        HousekeepFilesAuthRecord auth = authMap.get(remoteHost + "-SFTP");
        String username = auth.getUserName();
        String password = auth.getPassword();
        int port = auth.getPort();
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        this.addAuthTypeToConfig(auth.getAuthType(), config);
        JSch ssh = new JSch();
        if (auth.getAuthType() == AuthTypeEnum.KEY) {
            if (auth.getPassword() == null) {
                ssh.addIdentity(auth.getKeyPath());
            } else {
                ssh.addIdentity(auth.getKeyPath(), auth.getPassword());
            }
        }
        Session sftpSession = ssh.getSession(username, remoteHost, port);
        sftpSession.setConfig(config);
        sftpSession.setPassword(password);
        sftpSession.connect();
        Channel channel = sftpSession.openChannel("sftp");
        channel.connect();
        ChannelSftp sftpChannel = (ChannelSftp)channel;
        return new ConnectionToSftpServer(sftpSession, sftpChannel);
    }

    private void addAuthTypeToConfig(AuthTypeEnum authTypeEnum, Properties config) {
        HashMap<AuthTypeEnum, String> authNameMap = new HashMap<AuthTypeEnum, String>();
        authNameMap.put(AuthTypeEnum.PASSWORD, "password");
        authNameMap.put(AuthTypeEnum.KEY, "publickey");
        authNameMap.put(AuthTypeEnum.KERBEROS, "gssapi-with-mic");
        config.put("PreferredAuthentications", authNameMap.get(authTypeEnum));
    }

    protected FileInfo getRemoteFileInfo(AbstractTask task, ConnectionToRemoteServer connection, boolean isPathDir, String path) {
        List list = this.getRemoteFileInfoList(task, connection, isPathDir, path);
        if (list == null || list.size() == 0) {
            return null;
        }
        for (FileInfo fi : list) {
            if (!fi.getFilePath().equals(path)) continue;
            return fi;
        }
        throw new RuntimeException("\u3053\u3053\u306b\u5230\u9054\u3059\u308b\u3053\u3068\u306f\u306a\u3044");
    }

    protected List<FileInfo> getRemoteFileInfoList(AbstractTask task, ConnectionToRemoteServer connection, boolean isPathDir, String path) {
        ArrayList<FileInfo> rtnList = new ArrayList<FileInfo>();
        if (task.getTaskActionKind() == TaskActionKindEnum.create) {
            return rtnList;
        }
        try {
            ChannelSftp sftpChannel = ((ConnectionToSftpServer)connection).getSftpChannel();
            try {
                SftpATTRS attrs = sftpChannel.stat(path);
                rtnList.add(new FileInfo(path, true, (long)attrs.getMTime() * 1000L, false));
                return rtnList;
            }
            catch (Exception attrs) {
                Vector files;
                try {
                    files = sftpChannel.ls(path);
                }
                catch (SftpException sftpEx) {
                    this.dlog.error("\u2605\u2605\u2605 If not exist, CREATE DIRECTORY : " + path);
                    throw sftpEx;
                }
                List list = files.stream().filter(bean -> bean.getAttrs().isDir() == isPathDir).collect(Collectors.toList());
                if (list == null || list.size() == 0) {
                    return new ArrayList<FileInfo>();
                }
                for (ChannelSftp.LsEntry file : list) {
                    FileInfo fi = new FileInfo();
                    fi.setDirectory(file.getAttrs().isDir());
                    String fullPath = null;
                    if (fi.isDirectory()) {
                        if (file.getFilename().equals("..")) continue;
                        fullPath = file.getFilename().equals(".") ? path : this.fu.cleanPathStrWithSlash(this.fu.concatFilePaths(new String[]{this.fu.getParentDirPath(path), file.getFilename()}));
                    } else {
                        fullPath = this.fu.cleanPathStrWithSlash(this.fu.concatFilePaths(new String[]{this.fu.getParentDirPath(path), file.getFilename()}));
                    }
                    fi.setFilePath(fullPath);
                    fi.setLocked(false);
                    fi.setLastUpdTimeInMillis((long)file.getAttrs().getMTime() * 1000L);
                    rtnList.add(fi);
                }
                return rtnList;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getRemoteDirChildrenNameList(ChannelSftp channel, String dirPath) throws SftpException {
        if (!this.remoteDirExists(channel, dirPath)) {
            throw new RuntimeException("Path not found or file (not directory) exists. dirPath: " + dirPath);
        }
        try {
            List list = this.getRemoteDirChildrenList(channel, dirPath);
            return list.stream().map(e -> e.getFilename()).toList();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public List<ChannelSftp.LsEntry> getRemoteDirChildrenList(ChannelSftp channel, String dirPath) throws SftpException {
        if (!this.remoteDirExists(channel, dirPath)) {
            throw new RuntimeException("Path not found or file (not directory) exists. dirPath: " + dirPath);
        }
        try {
            List list = this.getRemoteAll(channel, dirPath);
            return list.stream().filter(f -> !f.getFilename().equals(".")).filter(f -> !f.getFilename().equals("..")).toList();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean remoteDirExists(ChannelSftp channel, String path) throws SftpException {
        List list = this.getRemoteAll(channel, path);
        if (list.size() == 0) {
            return false;
        }
        List<ChannelSftp.LsEntry> filteredList = list.stream().filter(f -> f.getFilename().equals(".")).toList();
        return filteredList.size() == 1;
    }

    public boolean remoteFileExists(ChannelSftp channel, String path) throws SftpException {
        List list = this.getRemoteAll(channel, path);
        if (list.size() == 0) {
            return false;
        }
        return !this.remoteDirExists(channel, path);
    }

    public boolean remoteExists(ChannelSftp channel, String path) throws SftpException {
        return this.getRemoteAll(channel, path).size() > 0;
    }

    public ChannelSftp.LsEntry getRemoteDetail(ChannelSftp channel, String path) throws SftpException {
        List list = this.getRemoteAll(channel, path);
        if (list.size() == 0) {
            return null;
        }
        if (this.remoteDirExists(channel, path)) {
            List<ChannelSftp.LsEntry> filteredList = list.stream().filter(f -> f.getFilename().equals(".")).toList();
            return filteredList.get(0);
        }
        List<ChannelSftp.LsEntry> filteredList = list.stream().filter(f -> f.getFilename().equals(new File(path).getName())).toList();
        return filteredList.get(0);
    }

    List<ChannelSftp.LsEntry> getRemoteAll(ChannelSftp channel, String path) throws SftpException {
        try {
            Vector lsEntries = channel.ls(path);
            return lsEntries.stream().toList();
        }
        catch (SftpException e) {
            if ("No such file".equals(e.getMessage())) {
                return new ArrayList<ChannelSftp.LsEntry>();
            }
            throw e;
        }
    }
}

