/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.tool.housekeepfiles.bl.task;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.lib.core.exception.checked.SingleAppException;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.lib.core.util.FileUtil;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import jp.ecuacion.tool.housekeepfiles.bean.ConnectionToRemoteServer;
import jp.ecuacion.tool.housekeepfiles.bl.task.TaskAttrCheckPtnEnum;
import jp.ecuacion.tool.housekeepfiles.dto.other.FileInfo;
import jp.ecuacion.tool.housekeepfiles.dto.record.HousekeepFilesAuthRecord;
import jp.ecuacion.tool.housekeepfiles.dto.record.HousekeepFilesTaskRecord;
import jp.ecuacion.tool.housekeepfiles.enums.IncidentTreatedAsEnum;
import jp.ecuacion.tool.housekeepfiles.enums.TaskActionKindEnum;
import jp.ecuacion.tool.housekeepfiles.enums.TaskPtnEnum;

public abstract class AbstractTask {
    protected TaskPtnEnum taskPtn;
    protected TaskAttrCheckPtnEnum inputRuleForSrcPathInfo;
    protected TaskAttrCheckPtnEnum inputRuleForDestPathInfo;
    protected boolean doesCreateOutputFileAutomatically = false;
    protected DetailLogger dlog = new DetailLogger((Object)this);
    protected FileUtil fu = new FileUtil();

    public AbstractTask() {
        TaskActionKindEnum taskActionKind = this.getTaskActionKind();
        if (taskActionKind == TaskActionKindEnum.create) {
            this.inputRuleForSrcPathInfo = TaskAttrCheckPtnEnum.PROHIBITED;
            this.inputRuleForDestPathInfo = TaskAttrCheckPtnEnum.REQUIRED;
        } else if (taskActionKind == TaskActionKindEnum.change) {
            this.inputRuleForSrcPathInfo = TaskAttrCheckPtnEnum.REQUIRED;
            this.inputRuleForDestPathInfo = TaskAttrCheckPtnEnum.REQUIRED;
        } else if (taskActionKind == TaskActionKindEnum.delete) {
            this.inputRuleForSrcPathInfo = TaskAttrCheckPtnEnum.REQUIRED;
            this.inputRuleForDestPathInfo = TaskAttrCheckPtnEnum.PROHIBITED;
        } else if (taskActionKind == TaskActionKindEnum.createFromOriginal) {
            this.inputRuleForSrcPathInfo = TaskAttrCheckPtnEnum.REQUIRED;
            this.inputRuleForDestPathInfo = TaskAttrCheckPtnEnum.ARBITRARY;
        }
    }

    public TaskAttrCheckPtnEnum getInputRuleForSrcPath() {
        return this.inputRuleForSrcPathInfo;
    }

    public TaskAttrCheckPtnEnum getInputRuleForDestPath() {
        return this.inputRuleForDestPathInfo;
    }

    public boolean doesCreateOutputFileAutomatically() {
        return this.doesCreateOutputFileAutomatically;
    }

    public void check(HousekeepFilesTaskRecord dtRec) throws AppException {
        ArrayList exList = new ArrayList();
        this.checkNeedRemoteServer(dtRec, exList);
        this.checkRequiredOrProhibited(exList, dtRec);
        if (exList.size() > 0) {
            throw new MultipleAppException(exList);
        }
        this.taskDependentCheck(dtRec, exList);
        if (exList.size() > 0) {
            throw new MultipleAppException(exList);
        }
    }

    public abstract void taskDependentCheck(HousekeepFilesTaskRecord var1, List<SingleAppException> var2);

    protected void checkNeedRemoteServer(HousekeepFilesTaskRecord taskRec, List<SingleAppException> exList) {
        boolean containsRemoteAction = this.isSrcPathLocal() != null && this.isSrcPathLocal() == false || this.isDestPathLocal() != null && this.isDestPathLocal() == false;
        this.checkTaskItemNoThrow(exList, taskRec.getTaskId(), this.taskPtn, containsRemoteAction ? TaskAttrCheckPtnEnum.REQUIRED : TaskAttrCheckPtnEnum.PROHIBITED, "remoteServer", (Object)taskRec.getRemoteServer());
    }

    private void checkRequiredOrProhibited(List<SingleAppException> exList, HousekeepFilesTaskRecord taskRec) {
        this.checkTaskItemNoThrow(exList, taskRec.getTaskId(), this.taskPtn, this.getInputRuleForSrcPath(), "srcPath", (Object)taskRec.getSrcPath());
        this.checkTaskItemNoThrow(exList, taskRec.getTaskId(), this.taskPtn, this.getInputRuleForDestPath(), "destPath", (Object)taskRec.getDestPath());
    }

    void checkTaskItemNoThrow(List<SingleAppException> exList, String taskId, TaskPtnEnum taskPtn, TaskAttrCheckPtnEnum checkPtn, String itemTitle, Object itemValue) {
        try {
            this.checkTaskItem(taskId, taskPtn, checkPtn, itemTitle, itemValue);
        }
        catch (BizLogicAppException ex) {
            exList.add((SingleAppException)ex);
        }
    }

    void checkTaskItem(String taskId, TaskPtnEnum taskPtn, TaskAttrCheckPtnEnum checkPtn, String itemTitle, Object itemValue) throws BizLogicAppException {
        boolean isEmpty;
        String taskPtnName = taskPtn == null ? "" : taskPtn.getName();
        boolean bl = isEmpty = itemValue == null || itemValue instanceof String && itemValue.equals("");
        if (checkPtn == TaskAttrCheckPtnEnum.REQUIRED && isEmpty) {
            throw new BizLogicAppException("MSG_ERR_TASK_REQUIRED_CHECK", new String[]{taskId, taskPtnName, PropertyFileUtil.getItemName((String)("HousekeepFilesTask." + itemTitle))});
        }
        if (checkPtn == TaskAttrCheckPtnEnum.PROHIBITED && !isEmpty) {
            throw new BizLogicAppException("MSG_ERR_TASK_PROHIBITED_CHECK", new String[]{taskId, taskPtnName, PropertyFileUtil.getItemName((String)("HousekeepFilesTask." + itemTitle))});
        }
    }

    public abstract TaskActionKindEnum getTaskActionKind();

    public abstract String getConnectionProtocol();

    public abstract ConnectionToRemoteServer getConnection(String var1, Map<String, HousekeepFilesAuthRecord> var2) throws Exception;

    public abstract Boolean isSrcPathLocal();

    public abstract Boolean isDestPathLocal();

    protected abstract FileInfo getRemoteFileInfo(AbstractTask var1, ConnectionToRemoteServer var2, boolean var3, String var4);

    protected abstract List<FileInfo> getRemoteFileInfoList(AbstractTask var1, ConnectionToRemoteServer var2, boolean var3, String var4);

    public void doTask(ConnectionToRemoteServer conn, HousekeepFilesTaskRecord taskRec, String srcPath, String destPath, List<AppException> warnList) throws Exception {
        this.doTaskInternal(conn, taskRec, srcPath, destPath, warnList);
    }

    protected abstract void doTaskInternal(ConnectionToRemoteServer var1, HousekeepFilesTaskRecord var2, String var3, String var4, List<AppException> var5) throws Exception;

    public boolean hasSrcPathInfo() {
        return this.getTaskActionKind() != TaskActionKindEnum.create;
    }

    public boolean hasDestPathInfo() {
        return this.getTaskActionKind() != TaskActionKindEnum.delete;
    }

    public FileInfo getToPathFileInfo(AbstractTask task, ConnectionToRemoteServer connection, boolean isPathDir, String path) throws Exception {
        if (this.isDestPathLocal().booleanValue()) {
            return this.getLocalFileInfo(path);
        }
        return this.getRemoteFileInfo(task, connection, isPathDir, path);
    }

    public List<FileInfo> getFromDirFileInfoList(AbstractTask task, ConnectionToRemoteServer connection, boolean isPathDir, String path) throws AppException {
        if (this.isSrcPathLocal().booleanValue()) {
            return this.getLocalFileInfoList(path);
        }
        return this.getRemoteFileInfoList(task, connection, isPathDir, path);
    }

    protected boolean localDirExists(String dirPath) {
        return new File(dirPath).exists() && new File(dirPath).isDirectory();
    }

    protected FileInfo getLocalFileInfo(String path) throws BizLogicAppException {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        FileInfo fi = new FileInfo();
        fi.setFilePath(path);
        fi.setDirectory(file.isDirectory());
        fi.setLastUpdTimeInMillis(file.lastModified());
        try {
            this.fu.isLocked(path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return fi;
    }

    protected List<FileInfo> getLocalFileInfoList(String path) throws BizLogicAppException {
        ArrayList<FileInfo> rtnList = new ArrayList<FileInfo>();
        List pathStrList = this.fu.getPathListFromPathWithWildcard(path);
        for (String strPath : pathStrList) {
            FileInfo fi = new FileInfo();
            File fileObj = new File(strPath);
            fi.setFilePath(strPath);
            fi.setDirectory(fileObj.isDirectory());
            fi.setLastUpdTimeInMillis(fileObj.lastModified());
            try {
                this.fu.isLocked(strPath);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            rtnList.add(fi);
        }
        return rtnList;
    }

    protected void treatIncident(IncidentTreatedAsEnum pattern, AppException ex, List<AppException> warnList) throws AppException {
        if (pattern == IncidentTreatedAsEnum.WARN) {
            warnList.add(ex);
        } else if (pattern == IncidentTreatedAsEnum.ERROR) {
            throw ex;
        }
    }

    protected void treatDestPathExists(HousekeepFilesTaskRecord taskRec, String destPath, List<AppException> warnList) throws AppException {
        this.treatIncident(taskRec.getActionForDestFileExists(), (AppException)((Object)new BizLogicAppException("MSG_ERR_DEST_PATH_EXISTS", new String[]{taskRec.getTaskId(), taskRec.getTaskName(), destPath})), warnList);
    }
}

