/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.tool.housekeepdb.tasklet;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.exception.checked.MultipleAppException;
import jp.ecuacion.lib.core.exception.unchecked.UncheckedAppException;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.lib.core.util.ValidationUtil;
import jp.ecuacion.tool.housekeepdb.bean.ColumnAndValueInfoBean;
import jp.ecuacion.tool.housekeepdb.bean.ColumnAndValueStringBean;
import jp.ecuacion.tool.housekeepdb.bean.forexceltable.DbConnectionInfoBean;
import jp.ecuacion.tool.housekeepdb.bean.forexceltable.HousekeepInfoBean;
import jp.ecuacion.tool.housekeepdb.bean.forexceltable.RelatedTableInfoBean;
import jp.ecuacion.tool.housekeepdb.bean.forexceltable.WhereConditionInfoBean;
import jp.ecuacion.tool.housekeepdb.lang.LangExcel;
import jp.ecuacion.tool.housekeepdb.util.SqlUtil;
import jp.ecuacion.util.poi.excel.table.bean.StringExcelTableBean;
import jp.ecuacion.util.poi.excel.table.reader.concrete.StringOneLineHeaderExcelTableReader;
import jp.ecuacion.util.poi.excel.table.reader.concrete.StringOneLineHeaderExcelTableToBeanReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.EncryptedDocumentException;
import org.slf4j.event.Level;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.stereotype.Component;

@Component
public class HousekeepDbTasklet
implements Tasklet {
    private static final int MAX_SELECT_LINES = 1000;
    private DetailLogger detailLogger = new DetailLogger((Object)this);
    private LangExcel lang = null;

    /*
     * Unable to fully structure code
     */
    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        excelPath = this.getExcelPathFromParameter(chunkContext);
        infoMap = this.getInfoMap(excelPath);
        this.lang = new LangExcel(Locale.of((String)infoMap.get("locale")));
        dbConnectionInfoMap = this.getDbConnectionInfoMap(excelPath);
        housekeepInfoList = this.getHousekeepInfoList(excelPath, dbConnectionInfoMap);
        this.detailLogger.info("Format Excel Version: " + (String)infoMap.get("format-version"));
        this.detailLogger.info("Locale              : " + (String)infoMap.get("locale"));
        this.detailLogger.info("database            : " + (String)infoMap.get("database"));
        msg = "- SQLs for per-record soft / hard delete will be logged with \"debug\" loglevel because of the amount.";
        this.detailLogger.info(msg);
        msg = "- The main select SQL is Looped and committed every 1000lines to prevent from using too much memory and time.";
        this.detailLogger.info(msg);
        msg = "- When 1 record selected by the execution of the main SQL, the log of the main select SQL occurs twice because the loop ends when the count of the main select SQL is zero.";
        this.detailLogger.info(msg);
        for (HousekeepInfoBean info : housekeepInfoList) {
            block16: {
                this.detailLogger.info("[task start ] " + info.getTaskId());
                this.detailLogger.info("DB Connection ID: " + info.getDbConnectionInfoId() + " / " + (info.isSoftDelete() != false ? "Soft Delete" : "Hard Delete") + " / Table Name: " + info.getTable() + ")");
                tableRecordDeleted = new LinkedHashMap<K, V>();
                conn = this.connectionSettings(dbConnectionInfoMap, info);
                selectSql = this.getMainSelectSql(info);
                while (true) lbl-1000:
                // 3 sources

                {
                    stmt = this.getStatement(conn, selectSql);
                    try {
                        rs = stmt.executeQuery();
                        isResultZero = true;
                        while (rs.next()) {
                            idValue = rs.getObject(info.getIdColumnInfo().getColumn());
                            if (this.needsSkipFromRelatedTableDataCheck(conn, info, idValue, rs)) continue;
                            isResultZero = false;
                            this.deleteRelatedData(conn, info, idValue, tableRecordDeleted);
                            this.deleteTargetData(conn, info, idValue, tableRecordDeleted);
                        }
                        if (!isResultZero) {
                            conn.commit();
                        }
                        break block16;
                    }
                    finally {
                        if (stmt == null) continue;
                        stmt.close();
                        continue;
                    }
                    break;
                }
                ** GOTO lbl-1000
                finally {
                    if (conn != null) {
                        conn.close();
                    }
                }
            }
            tableRecordDeleted.keySet().stream().forEach((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$execute$0(java.util.Map java.lang.String ), (Ljava/lang/String;)V)((HousekeepDbTasklet)this, tableRecordDeleted));
            this.detailLogger.info("[task finish] " + info.getTaskId());
        }
        return RepeatStatus.FINISHED;
    }

    private String getExcelPathFromParameter(ChunkContext chunkContext) throws BizLogicAppException {
        Map paramMap = chunkContext.getStepContext().getJobParameters();
        String excelPath = (String)paramMap.get("excelPath");
        if (excelPath == null) {
            throw new BizLogicAppException("MSG_ERR_EXCEL_PATH_NOT_SPECIFIED", new String[0]);
        }
        File excelFile = new File(excelPath);
        if (!excelFile.exists() || !excelFile.isFile()) {
            throw new BizLogicAppException("MSG_ERR_EXCEL_PATH_NOT_FOUND", new String[0]);
        }
        return excelPath;
    }

    private String getMainSelectSql(HousekeepInfoBean info) {
        ArrayList<Object> whereList = new ArrayList<Object>();
        whereList.addAll(info.getWhereConditionInfoList().stream().map(e -> e.getConditionColumnInfo()).toList());
        if (info.timestampColumnDefines()) {
            whereList.add(new ColumnAndValueStringBean("'" + SqlUtil.getTimestampNow((String)info.getDbConnectionInfo().getProtocol()) + "' - " + info.getTimestampColumn() + " > '" + info.getDeleteTargetInDays() + " days'"));
        }
        if (info.isSoftDelete()) {
            whereList.add(new ColumnAndValueInfoBean(info.getSoftDeleteColumn(), false, (Object)"false"));
        } else if (StringUtils.isNotEmpty((CharSequence)info.getSoftDeleteColumn())) {
            whereList.add(new ColumnAndValueInfoBean(info.getSoftDeleteColumn(), false, (Object)"true"));
        }
        String where = SqlUtil.getWhere(whereList);
        return "select * from " + info.getTable() + where + " order by " + info.getIdColumnInfo().getColumn() + " limit 1000";
    }

    private Connection connectionSettings(Map<String, DbConnectionInfoBean> dbConnectionInfoMap, HousekeepInfoBean info) throws BizLogicAppException, ClassNotFoundException, SQLException {
        DbConnectionInfoBean dbInfo = dbConnectionInfoMap.get(info.getDbConnectionInfoId());
        if (dbInfo == null) {
            throw new BizLogicAppException("MSG_ERR_DB_CONNECITON_INFO_ID_NOT_EXIST", new String[]{info.getDbConnectionInfoId()});
        }
        Class.forName(dbInfo.getDriverName());
        Connection conn = DriverManager.getConnection(this.getDbConnectionUrl(dbInfo), dbInfo.getUsername(), dbInfo.getPassword());
        conn.setAutoCommit(false);
        return conn;
    }

    private PreparedStatement getStatement(Connection conn, String sql) throws SQLException {
        return this.getStatement(conn, sql, Level.INFO);
    }

    private PreparedStatement getStatement(Connection conn, String sql, Level logLevel) throws SQLException {
        if (logLevel != null) {
            this.detailLogger.log(logLevel, sql);
        }
        return conn.prepareStatement(sql);
    }

    private boolean needsSkipFromRelatedTableDataCheck(Connection connection, HousekeepInfoBean info, Object id, ResultSet mainSqlRs) throws SQLException {
        List<RelatedTableInfoBean> relatedSkipList = info.getRelatedRecordTableInfoList().stream().filter(bean -> bean.getRelatedTableProcessPattern() == RelatedTableInfoBean.RelatedTableProcessPatternEnum.skipTargetTableRecordDeletion).toList();
        for (RelatedTableInfoBean relatedBean : relatedSkipList) {
            Object value = mainSqlRs.getObject(relatedBean.getTargetTableColumn());
            String selectSql = "select count(*) count from " + relatedBean.getRelatedTable() + " where " + relatedBean.getRelatedTableIdColumnInfo().getColumnAndValueInfo(value).getCondition();
            PreparedStatement stmt = this.getStatement(connection, selectSql, Level.DEBUG);
            ResultSet rs = stmt.executeQuery();
            rs.next();
            Integer integer = rs.getInt("count");
            if (integer <= 0) continue;
            return true;
        }
        return false;
    }

    private void deleteRelatedData(Connection conn, HousekeepInfoBean info, Object id, Map<String, Integer> tableRecordDeleted) throws SQLException {
        List<RelatedTableInfoBean> list = info.getRelatedRecordTableInfoList().stream().filter(bean -> bean.getRelatedTableProcessPattern() == RelatedTableInfoBean.RelatedTableProcessPatternEnum.deleteRelatedTableRecord).toList();
        for (RelatedTableInfoBean relatedInfo : list) {
            if (!tableRecordDeleted.containsKey(relatedInfo.getRelatedTable())) {
                tableRecordDeleted.put(relatedInfo.getRelatedTable(), 0);
            }
            ArrayList<ColumnAndValueInfoBean> updateSetList = new ArrayList<ColumnAndValueInfoBean>();
            if (info.isSoftDelete()) {
                updateSetList.add(relatedInfo.getSoftDeleteColumnInfo().getColumnAndValueInfo((Object)"true"));
                if (!StringUtils.isEmpty((CharSequence)relatedInfo.getSoftDeleteUpdateTimestampColumn())) {
                    updateSetList.add(relatedInfo.getSoftDeleteUpdateTimestampColumnInfo().getTimestampColumnNowInfo(info.getDbConnectionInfo().getProtocol()));
                }
                if (!StringUtils.isEmpty((CharSequence)relatedInfo.getSoftDeleteUpdateUserIdColumn())) {
                    updateSetList.add(relatedInfo.getSoftDeleteUpdateUserIdColumnAndValueInfo());
                }
            }
            String sqlTargetSelect = "select " + relatedInfo.getTargetTableColumn() + " from " + info.getTable() + " where " + info.getIdColumnInfo().getColumnAndValueInfo(id).getCondition();
            PreparedStatement stmt = this.getStatement(conn, sqlTargetSelect, Level.DEBUG);
            try {
                ResultSet rs = stmt.executeQuery();
                try {
                    rs.next();
                    Object val = rs.getObject(relatedInfo.getTargetTableColumn());
                    ArrayList<ColumnAndValueInfoBean> whereList = new ArrayList<ColumnAndValueInfoBean>();
                    whereList.add(relatedInfo.getRelatedTableIdColumnInfo().getColumnAndValueInfo(val));
                    if (!info.isSoftDelete() && !StringUtils.isEmpty((CharSequence)relatedInfo.getSoftDeleteColumn())) {
                        whereList.add(relatedInfo.getSoftDeleteColumnInfo().getColumnAndValueInfo((Object)"true"));
                    }
                    String softDeleteSql = "update " + relatedInfo.getRelatedTable() + SqlUtil.getUpdateSet(updateSetList);
                    String hardDeleteSql = "delete from " + relatedInfo.getRelatedTable();
                    String sql = info.isSoftDelete() ? softDeleteSql : hardDeleteSql;
                    sql = sql + SqlUtil.getWhere(whereList);
                    PreparedStatement delStmt = this.getStatement(conn, sql, Level.DEBUG);
                    int count = delStmt.executeUpdate();
                    tableRecordDeleted.put(relatedInfo.getRelatedTable(), tableRecordDeleted.get(relatedInfo.getRelatedTable()) + count);
                    delStmt.close();
                    this.logDeleteLines(relatedInfo.getRelatedTable(), count, relatedInfo.getRelatedTableIdColumnInfo().getColumnAndValueInfo(val).getCondition(), Level.DEBUG);
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
            finally {
                if (stmt == null) continue;
                stmt.close();
            }
        }
    }

    private void deleteTargetData(Connection conn, HousekeepInfoBean info, Object idValue, Map<String, Integer> tableRecordDeleted) throws SQLException {
        ArrayList<ColumnAndValueInfoBean> updateSetList = new ArrayList<ColumnAndValueInfoBean>();
        if (info.isSoftDelete()) {
            updateSetList.add(info.getSoftDeleteColumnInfo().getColumnAndValueInfo((Object)"true"));
            if (!StringUtils.isEmpty((CharSequence)info.getSoftDeleteUpdateTimestampColumn())) {
                updateSetList.add(info.getSoftDeleteUpdateTimestampColumnInfo().getTimestampColumnNowInfo(info.getDbConnectionInfo().getProtocol()));
            }
            if (!StringUtils.isEmpty((CharSequence)info.getSoftDeleteUpdateUserIdColumn())) {
                updateSetList.add(info.getSoftDeleteUpdateUserIdColumnAndValueInfo());
            }
        }
        String softDeleteSql = "update " + info.getTable() + SqlUtil.getUpdateSet(updateSetList);
        String hardDeleteSql = "delete from " + info.getTable();
        ArrayList<ColumnAndValueInfoBean> whereList = new ArrayList<ColumnAndValueInfoBean>();
        whereList.add(info.getIdColumnInfo().getColumnAndValueInfo(idValue));
        if (!info.isSoftDelete() && !StringUtils.isEmpty((CharSequence)info.getSoftDeleteColumn())) {
            whereList.add(info.getSoftDeleteColumnInfo().getColumnAndValueInfo((Object)"true"));
        }
        String sql = info.isSoftDelete() ? softDeleteSql : hardDeleteSql;
        PreparedStatement delStmt = this.getStatement(conn, sql = sql + SqlUtil.getWhere(whereList), Level.DEBUG);
        int count = delStmt.executeUpdate();
        if (count > 0 && !tableRecordDeleted.containsKey(info.getTable())) {
            tableRecordDeleted.put(info.getTable(), 0);
        }
        tableRecordDeleted.put(info.getTable(), tableRecordDeleted.get(info.getTable()) + count);
        delStmt.close();
        this.logDeleteLines(info.getTable(), count, info.getIdColumnInfo().getColumnAndValueInfo(idValue).getCondition(), Level.DEBUG);
    }

    private void logDeleteLines(String table, int count, String condition, Level logLevel) {
        if (logLevel != null) {
            this.detailLogger.log(logLevel, table + ": " + count + " lines deleted. (" + condition + ")");
        }
    }

    private String getDbConnectionUrl(DbConnectionInfoBean dbInfo) {
        String param = StringUtils.isEmpty((CharSequence)dbInfo.getSchema()) ? "" : "?currentSchema=" + dbInfo.getSchema();
        return "jdbc:" + dbInfo.getProtocol() + "://" + dbInfo.getServer() + ":" + dbInfo.getPort() + "/" + dbInfo.getDatabase() + param;
    }

    private Map<String, String> getInfoMap(String filePath) throws EncryptedDocumentException, AppException, IOException {
        List list = new StringOneLineHeaderExcelTableReader("Info", new String[]{"item", "value"}, null, 1, null).read(filePath);
        return list.stream().collect(Collectors.toMap(l -> (String)l.get(0), l -> (String)l.get(1)));
    }

    private Map<String, DbConnectionInfoBean> getDbConnectionInfoMap(String filePath) throws EncryptedDocumentException, URISyntaxException, IOException, AppException {
        Map<String, DbConnectionInfoBean> dbConnectionInfoMap = new StringOneLineHeaderExcelTableToBeanReader(DbConnectionInfoBean.class, this.lang.get("EXCEL_SHEET_DB_CONNECTION_SETTINGS"), this.lang.getHeaderLabels(DbConnectionInfoBean.HEADER_LABEL_KEYS), null, 1, null, (StringExcelTableBean[])new DbConnectionInfoBean[0]).readToBean(filePath).stream().collect(Collectors.toMap(e -> e.getId(), e -> e));
        dbConnectionInfoMap.values().stream().forEach(info -> {
            try {
                ValidationUtil.validateThenThrow((Object)info);
            }
            catch (MultipleAppException e) {
                throw new UncheckedAppException((AppException)e);
            }
        });
        return dbConnectionInfoMap;
    }

    private List<HousekeepInfoBean> getHousekeepInfoList(String filePath, Map<String, DbConnectionInfoBean> dbConnectionMap) throws EncryptedDocumentException, URISyntaxException, IOException, AppException {
        List housekeepList = new StringOneLineHeaderExcelTableToBeanReader(HousekeepInfoBean.class, this.lang.get("EXCEL_SHEET_HOUSEKEEP_DB_SETTINGS"), this.lang.getHeaderLabels(HousekeepInfoBean.HEADER_LABEL_KEYS), null, 1, null, (StringExcelTableBean[])new HousekeepInfoBean[0]).readToBean(filePath);
        List whereConditionList = new StringOneLineHeaderExcelTableToBeanReader(WhereConditionInfoBean.class, this.lang.get("EXCEL_SHEET_SEARCH_CONDITION_SETTINGS"), this.lang.getHeaderLabels(WhereConditionInfoBean.HEADER_LABEL_KEYS), null, 1, null, (StringExcelTableBean[])new WhereConditionInfoBean[0]).readToBean(filePath);
        List relatedTableList = new StringOneLineHeaderExcelTableToBeanReader(RelatedTableInfoBean.class, this.lang.get("EXCEL_SHEET_RELATED_TABLE_SETTINGS"), this.lang.getHeaderLabels(RelatedTableInfoBean.HEADER_LABEL_KEYS), null, 1, null, (StringExcelTableBean[])new RelatedTableInfoBean[0]).readToBean(filePath);
        HashSet<String> housekeepInfoTaskIdSet = new HashSet<String>();
        for (Object hpBean : housekeepList) {
            if (housekeepInfoTaskIdSet.contains(hpBean.getTaskId())) {
                throw new BizLogicAppException("MSG_ERR_TASK_ID_DUPLICATED", new String[]{hpBean.getTaskId()});
            }
            housekeepInfoTaskIdSet.add(hpBean.getTaskId());
            if (!dbConnectionMap.containsKey(hpBean.getDbConnectionInfoId())) {
                throw new BizLogicAppException("MSG_ERR_DB_CONN_ID_NOT_FOUND", new String[]{hpBean.getTaskId(), hpBean.getDbConnectionInfoId()});
            }
            hpBean.setDbConnectionInfo(dbConnectionMap.get(hpBean.getDbConnectionInfoId()));
            hpBean.setWhereConditionInfoList(whereConditionList.stream().filter(arg_0 -> HousekeepDbTasklet.lambda$getHousekeepInfoList$9((HousekeepInfoBean)hpBean, arg_0)).toList());
            hpBean.setRelatedRecordTableInfoList(relatedTableList.stream().filter(arg_0 -> HousekeepDbTasklet.lambda$getHousekeepInfoList$10((HousekeepInfoBean)hpBean, arg_0)).toList());
        }
        HashSet relSet = new HashSet();
        housekeepList.stream().forEach(bean -> relSet.addAll(bean.getRelatedRecordTableInfoList()));
        for (RelatedTableInfoBean relBean : relatedTableList) {
            if (relSet.contains(relBean)) continue;
            throw new BizLogicAppException("MSG_ERR_DATA_NOT_USED_REL", new String[]{relBean.getTaskId(), this.lang.get(relBean.getRelatedTableProcessPatternStringKey()), relBean.getTargetTableColumn(), relBean.getRelatedTable()});
        }
        HashSet condSet = new HashSet();
        housekeepList.stream().forEach(bean -> condSet.addAll(bean.getWhereConditionInfoList()));
        for (WhereConditionInfoBean condBean : whereConditionList) {
            if (condSet.contains(condBean)) continue;
            throw new BizLogicAppException("MSG_ERR_DATA_NOT_USED_COND", new String[]{condBean.getTaskId(), condBean.getConditionColumn()});
        }
        return housekeepList;
    }

    private static /* synthetic */ boolean lambda$getHousekeepInfoList$10(HousekeepInfoBean hpBean, RelatedTableInfoBean bean) {
        return bean.getTaskId().equals(hpBean.getTaskId());
    }

    private static /* synthetic */ boolean lambda$getHousekeepInfoList$9(HousekeepInfoBean hpBean, WhereConditionInfoBean bean) {
        return bean.getTaskId().equals(hpBean.getTaskId());
    }

    private /* synthetic */ void lambda$execute$0(Map tableRecordDeleted, String table) {
        this.detailLogger.info("[Delete lines] table:" + table + ", count:" + String.valueOf(tableRecordDeleted.get(table)));
    }
}

