/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.tool.housekeepdb.bean.forexceltable;

import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.jakartavalidation.validator.ConditionalEmpty;
import jp.ecuacion.lib.core.jakartavalidation.validator.ConditionalNotEmpty;
import jp.ecuacion.lib.core.jakartavalidation.validator.enums.ConditionPattern;
import jp.ecuacion.tool.housekeepdb.bean.ColumnAndValueInfoBean;
import jp.ecuacion.tool.housekeepdb.bean.ColumnInfoBean;
import jp.ecuacion.tool.housekeepdb.bean.forexceltable.DbConnectionInfoBean;
import jp.ecuacion.tool.housekeepdb.bean.forexceltable.RelatedTableInfoBean;
import jp.ecuacion.tool.housekeepdb.bean.forexceltable.WhereConditionInfoBean;
import jp.ecuacion.tool.housekeepdb.enums.TimestampKindEnum;
import jp.ecuacion.tool.housekeepdb.lang.LangExcel;
import jp.ecuacion.util.poi.excel.table.bean.StringExcelTableBean;
import org.apache.commons.lang3.StringUtils;

@ConditionalNotEmpty(propertyPath={"softDeleteColumn"}, conditionPropertyPath="isSoftDeleteInternalValue", conditionPattern=ConditionPattern.stringValueOfConditionPropertyPathIsEqualTo, conditionValueString={"SOFT_DELETE"})
@ConditionalEmpty.ConditionalEmptyList(value={@ConditionalEmpty(propertyPath={"timestampColumnKind", "deleteTargetInDays"}, conditionPropertyPath="timestampColumn", conditionPattern=ConditionPattern.valueOfConditionPropertyPathIsEmpty, notEmptyWhenConditionNotSatisfied=true), @ConditionalEmpty(propertyPath={"softDeleteUpdateTimestampColumn", "softDeleteUpdateUserIdColumn"}, conditionPropertyPath="isSoftDeleteInternalValue", conditionPattern=ConditionPattern.stringValueOfConditionPropertyPathIsEqualTo, conditionValueString={"HARD_DELETE"}), @ConditionalEmpty(propertyPath={"softDeleteUpdateUserIdColumnNeedsQuotationMark", "softDeleteUpdateUserIdColumnValue"}, conditionPropertyPath="softDeleteUpdateUserIdColumn", conditionPattern=ConditionPattern.valueOfConditionPropertyPathIsEmpty, notEmptyWhenConditionNotSatisfied=true)})
public class HousekeepInfoBean
extends StringExcelTableBean {
    public static final String DELETE_KIND_SOFT = "SOFT_DELETE";
    public static final String DELETE_KIND_HARD = "HARD_DELETE";
    @NotEmpty
    private String taskId;
    @NotEmpty
    private String dbConnectionInfoId;
    @NotEmpty
    private String isSoftDelete;
    @NotEmpty
    @Pattern(regexp="^HARD_DELETE|SOFT_DELETE$")
    private @NotEmpty @Pattern(regexp="^HARD_DELETE|SOFT_DELETE$") String isSoftDeleteInternalValue;
    @NotEmpty
    private String table;
    @NotEmpty
    private String idColumn;
    @NotEmpty
    @Pattern(regexp="^(\\(none\\)|quotes\\(\\'\\)$)")
    private @NotEmpty @Pattern(regexp="^(\\(none\\)|quotes\\(\\'\\)$)") String idColumnNeedsQuotationMark;
    private String timestampColumn;
    private String timestampColumnKind;
    private String deleteTargetInDays;
    private String softDeleteColumn;
    private String softDeleteUpdateTimestampColumn;
    private String softDeleteUpdateUserIdColumn;
    @Pattern(regexp="^(\\(none\\)|quotes\\(\\'\\)$)")
    private @Pattern(regexp="^(\\(none\\)|quotes\\(\\'\\)$)") String softDeleteUpdateUserIdColumnNeedsQuotationMark;
    private String softDeleteUpdateUserIdColumnValue;
    private ColumnInfoBean idColumnInfo;
    private ColumnInfoBean softDeleteColumnInfo;
    private ColumnInfoBean softDeleteUpdateTimestampColumnInfo;
    private ColumnAndValueInfoBean softDeleteUpdateUserIdColumnAndValueInfo;
    private DbConnectionInfoBean dbConnectionInfo;
    private List<WhereConditionInfoBean> whereConditionInfoList;
    private List<RelatedTableInfoBean> relatedRecordTableInfoList;
    public static final String[] HEADER_LABEL_KEYS = LangExcel.HousekeepDbSettings.HEADER_LABELS;

    @Nonnull
    protected String[] getFieldNameArray() {
        return new String[]{"taskId", "dbConnectionInfoId", "isSoftDelete", "isSoftDeleteInternalValue", "table", "idColumn", "idColumnNeedsQuotationMark", "timestampColumn", "timestampColumnKind", "deleteTargetInDays", "softDeleteColumn", "softDeleteUpdateTimestampColumn", "softDeleteUpdateUserIdColumn", "softDeleteUpdateUserIdColumnNeedsQuotationMark", "softDeleteUpdateUserIdColumnValue"};
    }

    public HousekeepInfoBean(List<String> colList) throws BizLogicAppException {
        super(colList);
    }

    public String getTaskId() {
        return this.taskId;
    }

    public boolean isSoftDelete() {
        if (this.isSoftDeleteInternalValue.equals(DELETE_KIND_HARD)) {
            return false;
        }
        if (this.isSoftDeleteInternalValue.equals(DELETE_KIND_SOFT)) {
            return true;
        }
        throw new RuntimeException("Not an assumed value: " + this.isSoftDelete);
    }

    public String getDbConnectionInfoId() {
        return this.dbConnectionInfoId;
    }

    public String getTable() {
        return this.table;
    }

    public String getSoftDeleteColumn() {
        return this.softDeleteColumn;
    }

    public String getSoftDeleteUpdateTimestampColumn() {
        return this.softDeleteUpdateTimestampColumn;
    }

    public String getSoftDeleteUpdateUserIdColumn() {
        return this.softDeleteUpdateUserIdColumn;
    }

    public String getSoftDeleteUpdateUserIdColumnNeedsQuotationMark() {
        return this.softDeleteUpdateUserIdColumnNeedsQuotationMark;
    }

    public String getSoftDeleteUpdateUserIdColumnValue() {
        return this.softDeleteUpdateUserIdColumnValue;
    }

    public TimestampKindEnum getTimestampColumnKind() {
        if (TimestampKindEnum.localDateTime.toString().equalsIgnoreCase(this.timestampColumnKind)) {
            return TimestampKindEnum.localDateTime;
        }
        if (TimestampKindEnum.offsetDateTime.toString().equalsIgnoreCase(this.timestampColumnKind)) {
            return TimestampKindEnum.offsetDateTime;
        }
        throw new RuntimeException("timestampColumnKindString is not an assumed value: " + this.timestampColumnKind);
    }

    public String getTimestampColumn() {
        return this.timestampColumn;
    }

    public int getDeleteTargetInDays() {
        return Integer.parseInt(this.deleteTargetInDays);
    }

    public boolean timestampColumnDefines() {
        return !StringUtils.isEmpty((CharSequence)this.timestampColumn);
    }

    public ColumnInfoBean getIdColumnInfo() {
        return this.idColumnInfo;
    }

    public ColumnInfoBean getSoftDeleteColumnInfo() {
        return this.softDeleteColumnInfo;
    }

    public ColumnInfoBean getSoftDeleteUpdateTimestampColumnInfo() {
        return this.softDeleteUpdateTimestampColumnInfo;
    }

    public ColumnAndValueInfoBean getSoftDeleteUpdateUserIdColumnAndValueInfo() {
        return this.softDeleteUpdateUserIdColumnAndValueInfo;
    }

    public DbConnectionInfoBean getDbConnectionInfo() {
        return this.dbConnectionInfo;
    }

    public void setDbConnectionInfo(DbConnectionInfoBean dbConnectionInfo) {
        this.dbConnectionInfo = dbConnectionInfo;
    }

    public List<WhereConditionInfoBean> getWhereConditionInfoList() {
        return this.whereConditionInfoList;
    }

    public void setWhereConditionInfoList(List<WhereConditionInfoBean> columnValueConditionInfoList) {
        this.whereConditionInfoList = columnValueConditionInfoList;
    }

    public List<RelatedTableInfoBean> getRelatedRecordTableInfoList() {
        return this.relatedRecordTableInfoList;
    }

    public void setRelatedRecordTableInfoList(List<RelatedTableInfoBean> relatedRecordTableInfoList) {
        this.relatedRecordTableInfoList = relatedRecordTableInfoList;
    }

    public void afterReading() throws AppException {
        this.constructColumnInfo();
    }

    private void constructColumnInfo() throws BizLogicAppException {
        this.idColumnInfo = new ColumnInfoBean(this.idColumn, this.idColumnNeedsQuotationMark);
        if (StringUtils.isNotEmpty((CharSequence)this.softDeleteColumn)) {
            this.softDeleteColumnInfo = new ColumnInfoBean(this.softDeleteColumn, false);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.softDeleteUpdateTimestampColumn)) {
            this.softDeleteUpdateTimestampColumnInfo = new ColumnInfoBean(this.softDeleteUpdateTimestampColumn, false);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.softDeleteUpdateUserIdColumn)) {
            this.softDeleteUpdateUserIdColumnAndValueInfo = new ColumnAndValueInfoBean(this.softDeleteUpdateUserIdColumn, this.softDeleteUpdateUserIdColumnNeedsQuotationMark, (Object)this.softDeleteUpdateUserIdColumnValue);
        }
    }
}

