/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.tool.housekeepdb.bean;

import jakarta.validation.constraints.NotEmpty;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.exception.unchecked.EclibRuntimeException;
import jp.ecuacion.tool.housekeepdb.bean.ColumnAndValueInfoBean;
import jp.ecuacion.tool.housekeepdb.util.SqlUtil;

public class ColumnInfoBean {
    private static final String NO_MARK = "(none)";
    private static final String QUOTES = "quotes(')";
    @NotEmpty
    private String column;
    private boolean needsQuotationMark;

    public ColumnInfoBean(String column, boolean needsQuationMark) {
        this.column = column;
        this.needsQuotationMark = needsQuationMark;
    }

    public ColumnInfoBean(String column, String needsQuotationMarkExcelString) throws BizLogicAppException {
        this.column = column;
        this.needsQuotationMark = this.getNeedsQuotationMarkBooleanFromExcelString(needsQuotationMarkExcelString);
    }

    private Boolean getNeedsQuotationMarkBooleanFromExcelString(String value) throws BizLogicAppException {
        if (value == null) {
            return null;
        }
        if (value.equals(NO_MARK)) {
            return false;
        }
        if (value.equals(QUOTES)) {
            return true;
        }
        throw new EclibRuntimeException("The value must be either '(none)' or 'quotes(')'.");
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public boolean isNeedsQuotationMark() {
        return this.needsQuotationMark;
    }

    public void setNeedsQuotationMark(boolean needsQuotationMark) {
        this.needsQuotationMark = needsQuotationMark;
    }

    public ColumnAndValueInfoBean getColumnAndValueInfo(Object value) {
        return new ColumnAndValueInfoBean(this.column, this.isNeedsQuotationMark(), value);
    }

    public ColumnAndValueInfoBean getTimestampColumnNowInfo(String protocol) {
        String now = SqlUtil.getTimestampNow((String)protocol);
        return new ColumnAndValueInfoBean(this.column, true, (Object)now);
    }
}

