/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.tool.housekeepdb.bean;

import jakarta.validation.constraints.NotEmpty;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.tool.housekeepdb.bean.ColumnInfoBean;
import jp.ecuacion.tool.housekeepdb.bean.SqlConditionInterface;

public class ColumnAndValueInfoBean
extends ColumnInfoBean
implements SqlConditionInterface {
    @NotEmpty
    private String value;

    public ColumnAndValueInfoBean(String column, boolean needsQuationMark, Object value) {
        super(column, needsQuationMark);
        this.value = this.getStringFromObject(value);
    }

    public ColumnAndValueInfoBean(String column, String needsQuationMark, Object value) throws BizLogicAppException {
        super(column, needsQuationMark);
        this.value = this.getStringFromObject(value);
    }

    private String getStringFromObject(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public Object getValue() {
        return this.value;
    }

    public String surroundWithQuotationMarks() {
        String mark = this.isNeedsQuotationMark() ? "'" : "";
        return mark + this.value.toString() + mark;
    }

    public String getCondition() {
        return this.getColumn() + " = " + this.surroundWithQuotationMarks();
    }
}

