/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.tool.housekeepdb.bean.forexceltable;

import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import jp.ecuacion.lib.core.exception.checked.AppException;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.lib.core.jakartavalidation.validator.ConditionalEmpty;
import jp.ecuacion.lib.core.jakartavalidation.validator.ConditionalNotEmpty;
import jp.ecuacion.tool.housekeepdb.bean.ColumnAndValueInfoBean;
import jp.ecuacion.tool.housekeepdb.bean.ColumnInfoBean;
import jp.ecuacion.tool.housekeepdb.bean.forexceltable.RelatedTableInfoBean;
import jp.ecuacion.tool.housekeepdb.lang.LangExcel;
import jp.ecuacion.util.poi.excel.table.bean.StringExcelTableBean;
import org.apache.commons.lang3.StringUtils;

@ConditionalNotEmpty(field={"softDeleteColumn"}, conditionField="isSoftDeleteInternalValue", conditionValue={"SOFT_DELETE"})
@ConditionalEmpty.ConditionalEmptyList(value={@ConditionalEmpty(field={"softDeleteUpdateUserIdColumnNeedsQuotationMark", "softDeleteUpdateUserIdColumnValue"}, conditionField="softDeleteUpdateUserIdColumn", conditionValueIsEmpty=true, notEmptyForOtherValues=true), @ConditionalEmpty(field={"softDeleteUpdateTimestampColumn", "softDeleteUpdateUserIdColumn"}, conditionField="isSoftDeleteInternalValue", conditionValue={"HARD_DELETE"}), @ConditionalEmpty(field={"softDeleteUpdateUserIdColumnNeedsQuotationMark", "softDeleteUpdateUserIdColumnValue"}, conditionField="softDeleteUpdateUserIdColumn", conditionValueIsEmpty=true, notEmptyForOtherValues=true)})
public class RelatedTableInfoBean
extends StringExcelTableBean {
    public static final String RELATED_TABLE_PROCESS_PATTERN_DELETE = "DELETE";
    public static final String RELATED_TABLE_PROCESS_PATTERN_CHECK_AND_SKIP_DELETE = "CHECK_AND_SKIP_DELETE";
    public static final String EMPTY = "";
    @NotEmpty
    private String taskId;
    @NotEmpty
    @Pattern(regexp="^HARD_DELETE|SOFT_DELETE$")
    private @NotEmpty @Pattern(regexp="^HARD_DELETE|SOFT_DELETE$") String isSoftDeleteInternalValue;
    @NotEmpty
    private String relatedTableProcessPattern;
    @NotEmpty
    @Pattern(regexp="^DELETE|CHECK_AND_SKIP_DELETE$")
    private @NotEmpty @Pattern(regexp="^DELETE|CHECK_AND_SKIP_DELETE$") String relatedTableProcessPatternInternalValue;
    @NotEmpty
    private String targetTableColumn;
    @NotEmpty
    private String relatedTable;
    @NotEmpty
    private String relatedTableIdColumn;
    @NotEmpty
    @Pattern(regexp="^(\\(none\\)|quotes\\(\\'\\)$)")
    private @NotEmpty @Pattern(regexp="^(\\(none\\)|quotes\\(\\'\\)$)") String relatedTableIdColumnNeedsQuotationMark;
    private String softDeleteColumn;
    private String softDeleteUpdateTimestampColumn;
    private String softDeleteUpdateUserIdColumn;
    @Pattern(regexp="^(\\(none\\)|quotes\\(\\'\\)$)")
    private @Pattern(regexp="^(\\(none\\)|quotes\\(\\'\\)$)") String softDeleteUpdateUserIdColumnNeedsQuotationMark;
    private String softDeleteUpdateUserIdColumnValue;
    private ColumnInfoBean relatedTableIdColumnInfo;
    private ColumnInfoBean softDeleteColumnInfo;
    private ColumnInfoBean softDeleteUpdateTimestampColumnInfo;
    private ColumnAndValueInfoBean softDeleteUpdateUserIdColumnAndValueInfo;
    public static final String[] HEADER_LABEL_KEYS = LangExcel.RelatedTableSettings.HEADER_LABELS;

    @Nonnull
    protected String[] getFieldNameArray() {
        return new String[]{"taskId", "isSoftDeleteInternalValue", "relatedTableProcessPattern", "relatedTableProcessPatternInternalValue", "targetTableColumn", "relatedTable", "relatedTableIdColumn", "relatedTableIdColumnNeedsQuotationMark", "softDeleteColumn", "softDeleteUpdateTimestampColumn", "softDeleteUpdateUserIdColumn", "softDeleteUpdateUserIdColumnNeedsQuotationMark", "softDeleteUpdateUserIdColumnValue"};
    }

    public RelatedTableInfoBean(List<String> colList) throws BizLogicAppException {
        super(colList);
    }

    public String getTaskId() {
        return this.taskId;
    }

    public RelatedTableProcessPatternEnum getRelatedTableProcessPattern() {
        return this.relatedTableProcessPatternInternalValue.equals(RELATED_TABLE_PROCESS_PATTERN_DELETE) ? RelatedTableProcessPatternEnum.deleteRelatedTableRecord : RelatedTableProcessPatternEnum.skipTargetTableRecordDeletion;
    }

    public String getRelatedTableProcessPatternStringKey() {
        return this.relatedTableProcessPatternInternalValue.equals(RELATED_TABLE_PROCESS_PATTERN_DELETE) ? "EXCEL_VALUE_RELATED_TABLE_PROCESS_PATTERN_DELETE" : "EXCEL_VALUE_RELATED_TABLE_PROCESS_PATTERN_CHECK_AND_SKIP_DELETE";
    }

    public String getTargetTableColumn() {
        return this.targetTableColumn;
    }

    public void setTargetTableColumn(String targetTableColumn) {
        this.targetTableColumn = targetTableColumn;
    }

    public String getRelatedTable() {
        return this.relatedTable;
    }

    public String getSoftDeleteColumn() {
        return this.softDeleteColumn;
    }

    public String getSoftDeleteUpdateTimestampColumn() {
        return this.softDeleteUpdateTimestampColumn;
    }

    public String getSoftDeleteUpdateUserIdColumn() {
        return this.softDeleteUpdateUserIdColumn;
    }

    public String getSoftDeleteUpdateUserIdColumnNeedsQuotationMark() {
        return this.softDeleteUpdateUserIdColumnNeedsQuotationMark;
    }

    public String getSoftDeleteUpdateUserIdColumnValue() {
        return this.softDeleteUpdateUserIdColumnValue;
    }

    public ColumnInfoBean getRelatedTableIdColumnInfo() {
        return this.relatedTableIdColumnInfo;
    }

    public ColumnInfoBean getSoftDeleteColumnInfo() {
        return this.softDeleteColumnInfo;
    }

    public ColumnInfoBean getSoftDeleteUpdateTimestampColumnInfo() {
        return this.softDeleteUpdateTimestampColumnInfo;
    }

    public ColumnAndValueInfoBean getSoftDeleteUpdateUserIdColumnAndValueInfo() {
        return this.softDeleteUpdateUserIdColumnAndValueInfo;
    }

    public void setRelatedTableIdColumnInfo(ColumnInfoBean relatedTableIdColumnInfo) {
        this.relatedTableIdColumnInfo = relatedTableIdColumnInfo;
    }

    public void afterReading() throws AppException {
        this.constructColumnInfo();
    }

    private void constructColumnInfo() throws BizLogicAppException {
        this.relatedTableIdColumnInfo = new ColumnInfoBean(this.relatedTableIdColumn, this.relatedTableIdColumnNeedsQuotationMark);
        if (StringUtils.isNotEmpty((CharSequence)this.softDeleteColumn)) {
            this.softDeleteColumnInfo = new ColumnInfoBean(this.softDeleteColumn, false);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.softDeleteUpdateTimestampColumn)) {
            this.softDeleteUpdateTimestampColumnInfo = new ColumnInfoBean(this.softDeleteUpdateTimestampColumn, false);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.softDeleteUpdateUserIdColumn)) {
            this.softDeleteUpdateUserIdColumnAndValueInfo = new ColumnAndValueInfoBean(this.softDeleteUpdateUserIdColumn, this.softDeleteUpdateUserIdColumnNeedsQuotationMark, (Object)this.softDeleteUpdateUserIdColumnValue);
        }
    }
}

