/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.tool.housekeepdb.bean;

import jakarta.validation.constraints.NotEmpty;
import jp.ecuacion.lib.core.exception.checked.BizLogicAppException;
import jp.ecuacion.tool.housekeepdb.bean.ColumnAndValueInfoBean;
import jp.ecuacion.tool.housekeepdb.util.SqlUtil;

public class ColumnInfoBean {
    private static final String noMark = "(none)";
    @NotEmpty
    private String column;
    private boolean needsQuotationMark;

    public ColumnInfoBean(String column, boolean needsQuationMark) {
        this.column = column;
        this.needsQuotationMark = needsQuationMark;
    }

    public ColumnInfoBean(String column, String needsQuotationMarkExcelString) throws BizLogicAppException {
        this.column = column;
        this.needsQuotationMark = this.getNeedsQuotationMarkBooleanFromExcelString(needsQuotationMarkExcelString);
    }

    private boolean getNeedsQuotationMarkBooleanFromExcelString(String value) throws BizLogicAppException {
        return !value.equals(noMark);
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public boolean isNeedsQuotationMark() {
        return this.needsQuotationMark;
    }

    public void setNeedsQuotationMark(boolean needsQuotationMark) {
        this.needsQuotationMark = needsQuotationMark;
    }

    public ColumnAndValueInfoBean getColumnAndValueInfo(Object value) {
        return new ColumnAndValueInfoBean(this.column, this.isNeedsQuotationMark(), value);
    }

    public ColumnAndValueInfoBean getTimestampColumnNowInfo(String protocol) {
        String now = new SqlUtil().getTimestampNow(protocol);
        return new ColumnAndValueInfoBean(this.column, true, (Object)now);
    }
}

