package jp.ecuacion.util.commandapi.web.controller;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.ResourceBundle;
import jp.ecuacion.lib.core.logging.DetailLogger;
import jp.ecuacion.lib.core.util.PropertyFileUtil;
import jp.ecuacion.splib.rest.exception.HttpStatusException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CommandApiController {

  private DetailLogger dtlLogger = new DetailLogger(this);
  // @Autowired
  // private HttpServletRequest request;

  @GetMapping("api/public/command")
  public void executeCommand(@RequestParam String scriptPathKey) throws Exception {
    String scriptPropertiesFilePath = PropertyFileUtil.getApp("app.scripts-properties-path");
    File scriptPropertiesFile = new File(scriptPropertiesFilePath);
    // scriptPropertiesFilePathのパスが存在しない場合はエラー
    if (!scriptPropertiesFile.exists()) {
      throw new RuntimeException(
          "No files exist at the path obtained from app.scripts-properties-path "
          + "defined in application.properties.");
    }

    // scripts.propertiesからの対象script path取得処理
    URLClassLoader urlLoader =
        new URLClassLoader(new URL[] {scriptPropertiesFile.getParentFile().toURI().toURL()});
    ResourceBundle bundle = ResourceBundle.getBundle(
        scriptPropertiesFile.getName().replace(".properties", ""), Locale.getDefault(), urlLoader);
    String scriptFilePath = bundle.getString(scriptPathKey);

    File scriptFile = new File(scriptFilePath);
    // scriptFilePathのパスが存在しない場合はエラー
    if (!scriptFile.exists()) {
      throw new RuntimeException("scriptFilePath not found.");
    }

    Runtime runtime = Runtime.getRuntime();
    Process p = runtime.exec(scriptFilePath.split(" "));
    dtlLogger.info(
        "command start: scriptPathKey = " + scriptPathKey + ", scriptFilePath = " + scriptFilePath);
    int rtn = p.waitFor(); // プロセス終了を待つ
    p.destroy(); // プロセスを明確に終了させ、資源を回収

    dtlLogger.info("command end. return code: " + rtn);

    if (rtn != 0) {
      // 500だとわかりにくいので、普段あまり見ない406を返すこととする
      throw new HttpStatusException(HttpStatus.NOT_ACCEPTABLE);
    }
  }
}
