/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.controller;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import jp.ecuacion.splib.web.controller.SplibBaseController;
import jp.ecuacion.splib.web.exception.HtmlFileNotAllowedToOpenException;
import jp.ecuacion.splib.web.exception.HtmlFileNotFoundException;
import jp.ecuacion.splib.web.util.SplibUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@Scope(value="prototype")
@RequestMapping(value={"/public/show", "/public/adminShow", "/account/show", "/admin/show"})
public class ShowPageController
extends SplibBaseController {
    @Autowired
    private SplibUtil util;

    @RequestMapping(value={"page"}, method={RequestMethod.POST, RequestMethod.GET})
    public String page(Model model, @RequestParam(value="id") String page) throws IOException {
        String expression = "^[a-zA-Z0-9_\\-/]*$";
        if (!page.matches(expression)) {
            return "redirect:/public/home/page";
        }
        ClassPathResource resource = new ClassPathResource("templates/" + page + ".html");
        if (!resource.exists()) {
            throw new HtmlFileNotFoundException(page);
        }
        this.htmlTagAttributeCheck(page, resource);
        return page;
    }

    private void htmlTagAttributeCheck(String page, ClassPathResource resource) throws IOException {
        String startTag;
        String html = resource.getContentAsString(Charset.defaultCharset());
        if (!html.contains(startTag = "<html") || html.replace(startTag, "").contains(startTag)) {
            throw new HtmlFileNotFoundException(page);
        }
        String htmlTag = html.substring(html.indexOf(startTag));
        List<String> list = Arrays.asList((htmlTag = htmlTag.substring(0, htmlTag.indexOf(">") + 1)).replaceAll("\n", " ").split(" ")).stream().filter(str -> str.contains("data-show-page-login-state")).toList();
        if (list.size() != 1 || !list.get(0).contains("=") || !list.get(0).split("=")[1].contains(this.util.getLoginState())) {
            throw new HtmlFileNotAllowedToOpenException(page);
        }
    }
}

