/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.bean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class MessagesBean {
    private boolean needsSuccessMessage = false;
    private WarnMessageBean warnMessage;
    private List<ErrorMessageBean> errorMessageList = new ArrayList<ErrorMessageBean>();

    private List<String> getErrorMessageList(String itemName) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (ErrorMessageBean bean : this.errorMessageList) {
            if (!bean.getItemNameSet().contains(itemName)) continue;
            returnList.add(bean.message);
        }
        return returnList;
    }

    public boolean getNeedsSuccessMessage() {
        return this.needsSuccessMessage;
    }

    public void setNeedsSuccessMessage(boolean needsSuccessMessage) {
        this.needsSuccessMessage = needsSuccessMessage;
    }

    public WarnMessageBean getWarnMessage() {
        return this.warnMessage;
    }

    public void setWarnMessage(WarnMessageBean warnMessage) {
        this.warnMessage = warnMessage;
    }

    public void setErrorMessage(String message, String ... itemKindIds) {
        this.errorMessageList.add(new ErrorMessageBean(message, itemKindIds));
    }

    public List<String> getErrorMessages() {
        ArrayList<String> rtnList = new ArrayList<String>();
        for (ErrorMessageBean bean : this.errorMessageList) {
            rtnList.add(bean.getMessage());
        }
        return rtnList;
    }

    public List<String> getErrorMessages(String itemKindId) {
        return this.getErrorMessageList(itemKindId);
    }

    public List<String> getErrorMessagesLinkedToItems() {
        return this.errorMessageList.stream().filter(e -> e.getItemNameSet().size() > 0).map(e -> e.getMessage()).collect(Collectors.toList());
    }

    public List<String> getErrorMessagesNotLinkedToItems() {
        return this.errorMessageList.stream().filter(e -> e.getItemNameSet().size() == 0).map(e -> e.getMessage()).collect(Collectors.toList());
    }

    public String isValid(String itemKindId) {
        return this.getErrorMessageList(itemKindId).size() > 0 ? "is-invalid" : "";
    }

    static class ErrorMessageBean {
        private String message;
        private Set<String> itemNameSet = new HashSet<String>();

        public ErrorMessageBean(String message) {
            this.message = message;
        }

        public ErrorMessageBean(String message, String ... itemName) {
            this.message = message;
            this.itemNameSet = new HashSet<String>(Arrays.asList(itemName == null ? new String[]{} : itemName).stream().map(itemKindId -> StringUtils.uncapitalize((String)itemKindId)).toList());
        }

        public String getMessage() {
            return this.message;
        }

        public Set<String> getItemNameSet() {
            return this.itemNameSet;
        }
    }

    public static class WarnMessageBean {
        private String messageId;
        private String message;
        private String buttonName;

        public WarnMessageBean(String messageId, String message) {
            this(messageId, message, null);
        }

        public WarnMessageBean(String messageId, String message, String buttonName) {
            this.messageId = messageId;
            this.message = message;
            this.buttonName = buttonName;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getButtonName() {
            return this.buttonName == null ? "" : this.buttonName;
        }
    }
}

