/*
 * Decompiled with CFR 0.152.
 */
package jp.ecuacion.splib.web.bean;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import jp.ecuacion.lib.core.annotation.RequireNonempty;
import jp.ecuacion.lib.core.util.ObjectsUtil;
import jp.ecuacion.splib.web.util.SplibSecurityUtil;
import org.apache.commons.lang3.StringUtils;

public class HtmlItem {
    @Nonnull
    protected String itemPropertyPath;
    protected String itemKindIdClass;
    @Nonnull
    protected String itemKindIdField;
    protected String itemNameKeyClass;
    protected String itemNameKeyField;
    protected HtmlItemConditionContainer<Boolean> isRequired = new HtmlItemConditionContainer<Boolean>(false);
    protected HtmlItemConditionContainer<Boolean> isRequiredOnSearch = new HtmlItemConditionContainer<Boolean>(false);

    public HtmlItem(@RequireNonempty String itemPropertyPath) {
        String itemPropertyPathClass;
        this.itemPropertyPath = ObjectsUtil.requireNonEmpty((String)itemPropertyPath);
        String string = itemPropertyPathClass = itemPropertyPath.contains(".") ? itemPropertyPath.substring(0, itemPropertyPath.lastIndexOf(".")) : null;
        this.itemKindIdClass = itemPropertyPathClass == null ? null : (itemPropertyPathClass.contains(".") ? itemPropertyPathClass.substring(itemPropertyPath.lastIndexOf(".") + 1) : itemPropertyPathClass);
        this.itemKindIdField = itemPropertyPath.contains(".") ? itemPropertyPath.substring(itemPropertyPath.lastIndexOf(".") + 1) : itemPropertyPath;
    }

    public String getItemPropertyPath() {
        return this.itemPropertyPath;
    }

    public String getItemKindId(String rootRecordName) {
        return (StringUtils.isEmpty((CharSequence)this.itemKindIdClass) ? rootRecordName : this.itemKindIdClass) + "." + this.itemKindIdField;
    }

    public HtmlItem itemNameKey(@RequireNonempty String itemNameKey) {
        ObjectsUtil.requireNonEmpty((String)itemNameKey);
        this.itemNameKeyClass = itemNameKey.contains(".") ? itemNameKey.substring(0, itemNameKey.lastIndexOf(".")) : null;
        this.itemNameKeyField = itemNameKey.contains(".") ? itemNameKey.substring(itemNameKey.lastIndexOf(".") + 1) : itemNameKey;
        return this;
    }

    public String getItemNameKey(String rootRecordName) {
        String classPart = !StringUtils.isEmpty((CharSequence)this.itemNameKeyClass) ? this.itemNameKeyClass : (!StringUtils.isEmpty((CharSequence)this.itemKindIdClass) ? this.itemKindIdClass : rootRecordName);
        String fieldPart = !StringUtils.isEmpty((CharSequence)this.itemNameKeyField) ? this.itemNameKeyField : this.itemKindIdField;
        return classPart + "." + fieldPart;
    }

    public HtmlItem required() {
        return this.required(true);
    }

    public HtmlItem required(boolean isRequired) {
        this.isRequired.setDefaultValue(isRequired);
        return this;
    }

    public HtmlItem required(HtmlItemConditionKeyEnum authKind, String authString, boolean isRequired) {
        this.isRequired.add(new HtmlItemCondition<Boolean>(authKind, authString, isRequired));
        return this;
    }

    public HtmlItem requiredOnSearch(boolean isRequired) {
        this.isRequiredOnSearch.setDefaultValue(isRequired);
        return this;
    }

    public HtmlItem requiredOnSearch(HtmlItemConditionKeyEnum authKind, String authString, boolean isRequired) {
        this.isRequiredOnSearch.add(new HtmlItemCondition<Boolean>(authKind, authString, isRequired));
        return this;
    }

    public boolean getRequiredOnSearch(String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
        return this.isRequiredOnSearch.getValue(loginState, bean);
    }

    @Deprecated
    public HtmlItem isNotEmpty(boolean isNotEmpty) {
        this.isRequired.setDefaultValue(isNotEmpty);
        return this;
    }

    @Deprecated
    public HtmlItem isNotEmpty(HtmlItemConditionKeyEnum authKind, String authString, boolean isNotEmpty) {
        this.isRequired.add(new HtmlItemCondition<Boolean>(authKind, authString, isNotEmpty));
        return this;
    }

    public boolean getIsNotEmpty(String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
        return this.isRequired.getValue(loginState, bean);
    }

    public static class HtmlItemConditionContainer<T> {
        private List<HtmlItemCondition<T>> list = new ArrayList<HtmlItemCondition<T>>();
        private T defaultValue;

        public HtmlItemConditionContainer(T defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void add(HtmlItemCondition<T> authInfo) {
            this.getList().add(authInfo);
        }

        private List<HtmlItemCondition<T>> getList() {
            return this.list;
        }

        public void setList(List<HtmlItemCondition<T>> list) {
            this.list = list;
        }

        public T getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
        }

        public T getValue(String loginState, SplibSecurityUtil.RolesAndAuthoritiesBean bean) {
            if (this.list == null) {
                this.list = new ArrayList<HtmlItemCondition<T>>();
            }
            for (HtmlItemCondition<T> info : this.list) {
                if (info.getConditionKey() == HtmlItemConditionKeyEnum.LOGIN_STATE) {
                    if (!info.getConditionValue().equals(loginState)) continue;
                    return info.getValue();
                }
                if (info.getConditionKey() == HtmlItemConditionKeyEnum.ROLE_CONTAINS) {
                    if (!bean.getRoleList().contains(info.getConditionValue())) continue;
                    return info.getValue();
                }
                if (info.getConditionKey() == HtmlItemConditionKeyEnum.AUTHORITY_CONTAINS) {
                    if (!bean.getAuthorityList().contains(info.getConditionValue())) continue;
                    return info.getValue();
                }
                throw new RuntimeException("Set appropriate one of the AuthKindEnum values");
            }
            return this.defaultValue;
        }
    }

    public static class HtmlItemCondition<T> {
        private HtmlItemConditionKeyEnum conditionKey;
        private String conditionValue;
        private T value;

        public HtmlItemCondition(HtmlItemConditionKeyEnum conditionKey, String conditionValue, T value) {
            this.conditionKey = conditionKey;
            this.conditionValue = conditionValue;
            this.value = value;
        }

        public HtmlItemConditionKeyEnum getConditionKey() {
            return this.conditionKey;
        }

        public String getConditionValue() {
            return this.conditionValue;
        }

        public T getValue() {
            return this.value;
        }
    }

    public static enum HtmlItemConditionKeyEnum {
        LOGIN_STATE,
        ROLE_CONTAINS,
        AUTHORITY_CONTAINS;

    }
}

